/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.network.physical.PhysicalNetworkBuilder;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.trafficassignment.TrafficAssignmentComponent;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.Node;

public class PhysicalNetwork
extends TrafficAssignmentComponent<PhysicalNetwork>
implements Serializable {
    private static final long serialVersionUID = -2794450367185361960L;
    private static final Logger LOGGER = Logger.getLogger(PhysicalNetwork.class.getCanonicalName());
    protected final PhysicalNetworkBuilder networkBuilder;
    public static final String MACROSCOPICNETWORK = MacroscopicNetwork.class.getCanonicalName();
    public final Links links = new Links();
    public final LinkSegments linkSegments = new LinkSegments();
    public final Nodes nodes = new Nodes();
    public final Modes modes = new Modes();

    public PhysicalNetwork(IdGroupingToken groupId, PhysicalNetworkBuilder networkBuilder) {
        super(groupId, PhysicalNetwork.class);
        this.networkBuilder = networkBuilder;
        this.networkBuilder.setIdGroupingToken(IdGenerator.createIdGroupingToken(this, this.getId()));
    }

    public IdGroupingToken getNetworkIdGroupingToken() {
        return this.networkBuilder.getIdGroupingToken();
    }

    public class Modes
    implements Iterable<Mode> {
        private Map<Long, Mode> modeMap = new TreeMap<Long, Mode>();

        protected Mode registerMode(Mode mode) {
            return this.modeMap.put(mode.getId(), mode);
        }

        @Override
        public Iterator<Mode> iterator() {
            return this.modeMap.values().iterator();
        }

        public Mode registerNewMode(long externalModeId, String name, double pcu) {
            Mode newMode = PhysicalNetwork.this.networkBuilder.createMode(externalModeId, name, pcu);
            this.registerMode(newMode);
            return newMode;
        }

        public int getNumberOfModes() {
            return this.modeMap.size();
        }

        public Mode getModeById(long id) {
            return this.modeMap.get(id);
        }

        public Mode getFirst() {
            return this.getModeById(0L);
        }

        public Mode getModeByExternalId(Object externalId, boolean convertToLong) {
            if (convertToLong) {
                try {
                    long value = Long.valueOf(externalId.toString());
                    return this.getModeByExternalId(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getModeByExternalId(externalId);
        }

        public Mode getModeByExternalId(Object externalId) {
            for (Mode mode : this.modeMap.values()) {
                if (!mode.getExternalId().equals(externalId)) continue;
                return mode;
            }
            return null;
        }
    }

    public class Nodes
    implements Iterable<Node> {
        private Map<Long, Node> nodeMap = new TreeMap<Long, Node>();

        protected Node registerNode(Node node) {
            return this.nodeMap.put(node.getId(), node);
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodeMap.values().iterator();
        }

        public Node registerNewNode() {
            Node newNode = PhysicalNetwork.this.networkBuilder.createNode();
            this.registerNode(newNode);
            return newNode;
        }

        public int getNumberOfNodes() {
            return this.nodeMap.size();
        }

        public Node getNodeById(long id) {
            return this.nodeMap.get(id);
        }
    }

    public class LinkSegments
    implements Iterable<LinkSegment> {
        private Map<Long, LinkSegment> linkSegmentMap = new TreeMap<Long, LinkSegment>();
        private Map<Long, List<LinkSegment>> linkSegmentMapByStartNodeId = new HashMap<Long, List<LinkSegment>>();

        protected void registerLinkSegment(LinkSegment linkSegment) throws PlanItException {
            this.linkSegmentMap.put(linkSegment.getId(), linkSegment);
            Node startNode = (Node)linkSegment.getUpstreamVertex();
            if (!this.linkSegmentMapByStartNodeId.containsKey(startNode.getId())) {
                this.linkSegmentMapByStartNodeId.put(startNode.getId(), new ArrayList());
            }
            this.linkSegmentMapByStartNodeId.get(startNode.getId()).add(linkSegment);
        }

        @Override
        public Iterator<LinkSegment> iterator() {
            return this.linkSegmentMap.values().iterator();
        }

        public LinkSegment getLinkSegmentByStartAndEndNodeId(long startId, long endId) {
            if (!this.linkSegmentMapByStartNodeId.containsKey(startId)) {
                LOGGER.warning(LoggingUtils.createNetworkPrefix(PhysicalNetwork.this.getId()) + String.format("no link segment with start node %d has been registered in the network", startId));
                return null;
            }
            List<LinkSegment> linkSegmentsForCurrentStartNode = this.linkSegmentMapByStartNodeId.get(startId);
            for (LinkSegment linkSegment : linkSegmentsForCurrentStartNode) {
                Node endNode = (Node)linkSegment.getDownstreamVertex();
                if (endNode.getId() != endId) continue;
                return linkSegment;
            }
            LOGGER.warning(LoggingUtils.createNetworkPrefix(PhysicalNetwork.this.getId()) + String.format("no link segment with start node %d and end node %d has been registered in the network", startId, endId));
            return null;
        }

        public LinkSegment createDirectionalLinkSegment(Link parentLink, boolean directionAB) throws PlanItException {
            LinkSegment linkSegment = PhysicalNetwork.this.networkBuilder.createLinkSegment(parentLink, directionAB);
            return linkSegment;
        }

        public void registerLinkSegment(Link parentLink, LinkSegment linkSegment, boolean directionAB) throws PlanItException {
            parentLink.registerLinkSegment(linkSegment, directionAB);
            this.registerLinkSegment(linkSegment);
        }

        public LinkSegment getLinkSegment(long id) {
            return this.linkSegmentMap.get(id);
        }

        public int getNumberOfLinkSegments() {
            return this.linkSegmentMap.size();
        }

        public LinkSegment getLinkSegmentByExternalId(Object externalId, boolean convertToLong) {
            try {
                if (convertToLong) {
                    long value = Long.valueOf(externalId.toString());
                    return this.getLinkSegmentByExternalId(value);
                }
                return this.getLinkSegmentByExternalId(externalId);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getLinkSegmentByExternalId(externalId);
            }
        }

        public LinkSegment getLinkSegmentByExternalId(Object externalId) {
            for (LinkSegment linkSegment : this.linkSegmentMap.values()) {
                if (!linkSegment.getExternalId().equals(externalId)) continue;
                return linkSegment;
            }
            return null;
        }
    }

    public class Links
    implements Iterable<Link> {
        private Map<Long, Link> linkMap = new TreeMap<Long, Link>();

        protected Link registerLink(Link link) {
            return this.linkMap.put(link.getId(), link);
        }

        @Override
        public Iterator<Link> iterator() {
            return this.linkMap.values().iterator();
        }

        public Link registerNewLink(Node nodeA, Node nodeB, double length, String name) throws PlanItException {
            Link newLink = PhysicalNetwork.this.networkBuilder.createLink(nodeA, nodeB, length, name);
            this.registerLink(newLink);
            return newLink;
        }

        public Link getLink(long id) {
            return this.linkMap.get(id);
        }

        public int getNumberOfLinks() {
            return this.linkMap.size();
        }
    }
}

