/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical.macroscopic;

import java.util.logging.Logger;
import org.planit.network.physical.LinkSegmentImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class MacroscopicLinkSegmentImpl
extends LinkSegmentImpl
implements MacroscopicLinkSegment {
    private static final long serialVersionUID = 4574164258794764853L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    protected MacroscopicLinkSegmentType linkSegmentType = null;

    public MacroscopicLinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) {
        super(groupId, parentLink, directionAB);
    }

    @Override
    public double computeCapacity() {
        return this.getLinkSegmentType().getCapacityPerLane() * (double)this.getNumberOfLanes();
    }

    @Override
    public double computeFreeFlowTravelTime(Mode mode) throws PlanItException {
        PlanItException.throwIf(!this.isModeAllowedThroughLink(mode), "mode not allowed on link segment, no free flow time can be computed");
        double linkLength = this.getParentLink().getLength();
        double maximumSpeed = this.getMaximumSpeed(mode);
        double segmentTypeMaximumSpeed = this.getLinkSegmentType().getModeProperties(mode).getMaxSpeed();
        double computedMaximumSpeed = Math.min(maximumSpeed, segmentTypeMaximumSpeed);
        return linkLength / computedMaximumSpeed;
    }

    @Override
    public boolean isModeAllowedThroughLink(Mode mode) {
        return this.linkSegmentType.getModeProperties(mode) != null;
    }

    @Override
    public void setLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType) {
        this.linkSegmentType = linkSegmentType;
    }

    @Override
    public MacroscopicLinkSegmentType getLinkSegmentType() {
        return this.linkSegmentType;
    }
}

