/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.property.IterationIndexOutputProperty;
import org.planit.output.property.ModeExternalIdOutputProperty;
import org.planit.output.property.ModeIdOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.output.property.RunIdOutputProperty;
import org.planit.output.property.TimePeriodExternalIdOutputProperty;
import org.planit.output.property.TimePeriodIdOutputProperty;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;

public abstract class OutputTypeAdapterImpl
implements OutputTypeAdapter {
    protected TrafficAssignment trafficAssignment;
    protected OutputType outputType;

    protected Object getCommonPropertyValue(OutputProperty outputProperty, Mode mode, TimePeriod timePeriod) {
        try {
            switch (outputProperty) {
                case MODE_EXTERNAL_ID: {
                    return ModeExternalIdOutputProperty.getModeExternalId(mode);
                }
                case MODE_ID: {
                    return ModeIdOutputProperty.getModeId(mode);
                }
                case RUN_ID: {
                    return RunIdOutputProperty.getRunId(this.trafficAssignment);
                }
                case TIME_PERIOD_EXTERNAL_ID: {
                    return TimePeriodExternalIdOutputProperty.getTimePeriodExternalId(timePeriod);
                }
                case TIME_PERIOD_ID: {
                    return TimePeriodIdOutputProperty.getTimePeriodId(timePeriod);
                }
                case ITERATION_INDEX: {
                    return IterationIndexOutputProperty.getIterationIndex(this.trafficAssignment);
                }
            }
            return null;
        }
        catch (PlanItException e) {
            return e;
        }
    }

    public OutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        this.outputType = outputType;
        this.trafficAssignment = trafficAssignment;
    }

    @Override
    public OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public int getIterationIndexForSubOutputType(SubOutputTypeEnum outputTypeEnum) throws PlanItException {
        return this.trafficAssignment.getSimulationData().getIterationIndex();
    }
}

