/*
 * Decompiled with CFR 0.152.
 */
package org.planit.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.planit.output.enums.RouteIdType;
import org.planit.route.RouteImpl;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.Pair;
import org.planit.utils.network.virtual.Centroid;

public interface Route {
    public Boolean addEdgeSegment(EdgeSegment var1);

    public Iterator<EdgeSegment> getIterator();

    public String toString(RouteIdType var1);

    public List<EdgeSegment> getPath();

    public long getId();

    public static Route createRoute(IdGroupingToken groupId, Centroid destination, Pair<Double, EdgeSegment>[] vertexPathAndCost) {
        long downstreamVertexId = destination.getId();
        EdgeSegment edgeSegment = vertexPathAndCost[(int)downstreamVertexId].getSecond();
        ArrayList<EdgeSegment> pathEdgeSegments = new ArrayList<EdgeSegment>();
        while (edgeSegment != null) {
            pathEdgeSegments.add(edgeSegment);
            downstreamVertexId = edgeSegment.getUpstreamVertex().getId();
            edgeSegment = vertexPathAndCost[(int)downstreamVertexId].getSecond();
        }
        Collections.reverse(pathEdgeSegments);
        return new RouteImpl(groupId, pathEdgeSegments);
    }
}

