/*
 * Decompiled with CFR 0.152.
 */
package org.planit.route;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.planit.output.enums.RouteIdType;
import org.planit.route.Route;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.ConnectoidSegment;

public class RouteImpl
implements Route {
    private long id;
    private final List<EdgeSegment> path;

    private String getNodeRouteString(Function<Node, Object> idGetter) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : this.path) {
            Vertex vertex = edgeSegment.getUpstreamVertex();
            if (!(vertex instanceof Node)) continue;
            Node node = (Node)vertex;
            builder.append(idGetter.apply(node));
            if (!(edgeSegment.getDownstreamVertex() instanceof Node)) continue;
            builder.append(",");
        }
        builder.append("]");
        return new String(builder);
    }

    private String getEdgeSegmentRouteString(Function<EdgeSegment, Object> idGetter) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : this.path) {
            builder.append(idGetter.apply(edgeSegment));
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return new String(builder);
    }

    private String getRouteByEdgeSegmentExternalIdString() {
        return this.getEdgeSegmentRouteString(edgeSegment -> {
            if (edgeSegment instanceof ConnectoidSegment && !((ConnectoidSegment)edgeSegment).hasExternalId()) {
                return "Connectoid Undefined";
            }
            return edgeSegment.getExternalId();
        });
    }

    private String getRouteByEdgeSegmentIdString() {
        return this.getEdgeSegmentRouteString(EdgeSegment::getId);
    }

    private String getRouteByNodeExternalIdString() {
        return this.getNodeRouteString(Node::getExternalId);
    }

    private String getRouteByNodeIdString() {
        return this.getNodeRouteString(Vertex::getId);
    }

    protected RouteImpl(IdGroupingToken groupId) {
        this.id = IdGenerator.generateId(groupId, Route.class);
        this.path = new ArrayList<EdgeSegment>();
    }

    protected RouteImpl(IdGroupingToken groupId, List<EdgeSegment> pathEdgeSegments) {
        this.id = IdGenerator.generateId(groupId, Route.class);
        this.path = pathEdgeSegments;
    }

    @Override
    public Boolean addEdgeSegment(EdgeSegment edgeSegment) {
        return this.path.add(edgeSegment);
    }

    @Override
    public Iterator<EdgeSegment> getIterator() {
        return this.path.iterator();
    }

    @Override
    public List<EdgeSegment> getPath() {
        return this.path;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String toString(RouteIdType pathOutputType) {
        switch (pathOutputType) {
            case LINK_SEGMENT_EXTERNAL_ID: {
                return this.getRouteByEdgeSegmentExternalIdString();
            }
            case LINK_SEGMENT_ID: {
                return this.getRouteByEdgeSegmentIdString();
            }
            case NODE_EXTERNAL_ID: {
                return this.getRouteByNodeExternalIdString();
            }
            case NODE_ID: {
                return this.getRouteByNodeIdString();
            }
        }
        return "";
    }
}

