/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.reflection;

import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StackWalkerUtil {
    private static StackWalker getStackWalkerInstance() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }

    private static List<StackWalker.StackFrame> convertStreamToList(Stream<StackWalker.StackFrame> stackFrameStream) {
        return stackFrameStream.collect(Collectors.toList());
    }

    public static List<StackWalker.StackFrame> getStackFramesAsList() {
        return StackWalkerUtil.getStackWalkerInstance().walk(StackWalkerUtil::convertStreamToList);
    }

    public static Optional<StackWalker.StackFrame> getFirstStackFrame() {
        return StackWalkerUtil.getStackWalkerInstance().walk(stackFrameStream -> stackFrameStream.findFirst());
    }

    public static StackWalker.StackFrame getStackFrameWithOffset(int skipOffset) {
        return StackWalkerUtil.getStackWalkerInstance().walk(stackFrameStream -> stackFrameStream.skip(skipOffset).findFirst().orElse(null));
    }

    public static String getCallingMethodName() {
        StackWalker.StackFrame callingStackFrame = StackWalkerUtil.getStackFrameWithOffset(2);
        return callingStackFrame != null ? callingStackFrame.getMethodName() : "unknown";
    }

    public static String getCallingClassName() {
        StackWalker.StackFrame callingStackFrame = StackWalkerUtil.getStackFrameWithOffset(2);
        return callingStackFrame != null ? callingStackFrame.getClassName() : "unknown";
    }

    public static MethodType getCallingMethodType() {
        StackWalker.StackFrame callingStackFrame = StackWalkerUtil.getStackFrameWithOffset(2);
        return callingStackFrame != null ? callingStackFrame.getMethodType() : null;
    }
}

