/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.geometry.iso.PrecisionModel;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.DoublePointArray;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.PrecisionType;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PositionFactoryImpl
implements Serializable,
Factory,
PositionFactory {
    private static final long serialVersionUID = 1L;
    private final Precision precision;
    final CoordinateReferenceSystem crs;
    private Map<RenderingHints.Key, Object> hintsWeCareAbout = new HashMap<RenderingHints.Key, Object>();

    public PositionFactoryImpl() {
        this((Hints)null);
    }

    public PositionFactoryImpl(Hints hints) {
        if (hints == null) {
            this.crs = DefaultGeographicCRS.WGS84;
            this.precision = new PrecisionModel();
        } else {
            this.crs = (CoordinateReferenceSystem)hints.get(Hints.CRS);
            this.precision = new PrecisionModel();
        }
        this.hintsWeCareAbout.put(Hints.CRS, this.crs);
        this.hintsWeCareAbout.put(Hints.PRECISION, this.precision);
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs) {
        this(crs, new PrecisionModel(PrecisionType.DOUBLE));
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs, Precision precision) {
        assert (precision.getType() == PrecisionType.DOUBLE);
        this.crs = crs;
        this.precision = precision;
        this.hintsWeCareAbout.put(Hints.CRS, crs);
        this.hintsWeCareAbout.put(Hints.PRECISION, precision);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    @Override
    public DirectPosition createDirectPosition() throws MismatchedDimensionException {
        return new DirectPositionImpl(this.crs);
    }

    @Override
    public DirectPosition createDirectPosition(double[] coords) throws MismatchedDimensionException {
        if (coords != null) {
            return new DirectPositionImpl(this.crs, coords);
        }
        return new DirectPositionImpl(this.crs);
    }

    @Override
    public Position createPosition(Position position) {
        DirectPosition directPosition = position.getDirectPosition();
        return new DirectPositionImpl(directPosition);
    }

    @Override
    public PointArrayImpl createPointArray() {
        return new PointArrayImpl(this.crs);
    }

    @Override
    public DoublePointArray createPointArray(double[] array, int start, int end) {
        return new DoublePointArray(this.crs, array, start, end);
    }

    @Override
    public PointArray createPointArray(float[] array, int start, int end) {
        PointArrayImpl pointArray = this.createPointArray();
        int D2 = this.crs.getCoordinateSystem().getDimension();
        if (D2 == 2) {
            for (int i = start; i < end; i += D2) {
                double[] ordinates = new double[]{array[i], array[i + 1]};
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        } else if (D2 == 3) {
            for (int i = start; i < end; i += D2) {
                double[] ordinates = new double[]{array[i], array[i + 1], array[i + 2]};
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        } else {
            for (int i = start; i < end; i += D2) {
                double[] ordinates = new double[D2];
                for (int o = 0; o < D2; ++o) {
                    ordinates[o] = array[i + o];
                }
                pointArray.add(new DirectPositionImpl(this.crs, ordinates));
            }
        }
        return pointArray;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public Precision getPrecision() {
        return this.precision;
    }
}

