/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.aggregate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.geometry.iso.aggregate.MultiCurveImpl;
import org.geotools.geometry.iso.aggregate.MultiPointImpl;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.aggregate.MultiSurfaceImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.aggregate.MultiCurve;
import org.opengis.geometry.aggregate.MultiPoint;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AggregateFactoryImpl
implements Factory,
AggregateFactory {
    private CoordinateReferenceSystem crs;
    private Map hintsWeCareAbout = new HashMap();

    public AggregateFactoryImpl() {
        this((Hints)null);
    }

    public AggregateFactoryImpl(Hints hints) {
        this.crs = hints == null ? DefaultGeographicCRS.WGS84 : (CoordinateReferenceSystem)hints.get(Hints.CRS);
        this.hintsWeCareAbout.put(Hints.CRS, this.crs);
    }

    public AggregateFactoryImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.hintsWeCareAbout.put(Hints.CRS, crs);
    }

    public Map getImplementationHints() {
        return Collections.unmodifiableMap(this.hintsWeCareAbout);
    }

    @Override
    public MultiPrimitive createMultiPrimitive(Set<Primitive> primitives) {
        return new MultiPrimitiveImpl(this.crs, (Set<? extends Primitive>)primitives);
    }

    @Override
    public MultiPoint createMultiPoint(Set<Point> points) {
        return new MultiPointImpl(this.crs, points);
    }

    @Override
    public MultiCurve createMultiCurve(Set<OrientableCurve> curves) {
        return new MultiCurveImpl(this.crs, curves);
    }

    @Override
    public MultiSurface createMultiSurface(Set<OrientableSurface> surfaces) {
        return new MultiSurfaceImpl(this.crs, surfaces);
    }
}

