/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.List;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedRing;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class CompoundRing
extends LinearRing
implements CompoundCurvedGeometry<LinearRing>,
CurvedRing {
    private static final long serialVersionUID = -5796254063449438787L;
    CompoundCurve delegate;
    LineString linearized;

    public CompoundRing(List<LineString> components, GeometryFactory factory, double tolerance) {
        this(new CompoundCurve(components, factory, tolerance));
    }

    public CompoundRing(CompoundCurve delegate) {
        super(CircularRing.FAKE_RING_2D, delegate.getFactory());
        this.delegate = delegate;
        if (!delegate.isClosed()) {
            throw new IllegalArgumentException("The components do not form a closed ring");
        }
    }

    @Override
    public double getTolerance() {
        return this.delegate.getTolerance();
    }

    @Override
    public List<LineString> getComponents() {
        return this.delegate.components;
    }

    @Override
    public int getCoordinatesDimension() {
        return this.delegate.getCoordinatesDimension();
    }

    @Override
    public LinearRing linearize() {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(this.delegate.tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public LinearRing linearize(double tolerance) {
        CoordinateSequence cs = this.delegate.getLinearizedCoordinateSequence(tolerance);
        return this.getFactory().createLinearRing(cs);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public int getDimension() {
        return super.getDimension();
    }

    @Override
    public int getBoundaryDimension() {
        return super.getDimension();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getGeometryType() {
        return "CompoundRing";
    }

    @Override
    public CompoundRing reverse() {
        return (CompoundRing)super.reverse();
    }

    @Override
    public CompoundRing reverseInternal() {
        CompoundCurve reversedDelegate = this.delegate.reverse();
        return new CompoundRing(reversedDelegate);
    }

    @Override
    public int getNumGeometries() {
        return this.delegate.getNumGeometries();
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.delegate.getGeometryN(n);
    }

    @Override
    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    @Override
    public int getSRID() {
        return super.getSRID();
    }

    @Override
    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    @Override
    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    @Override
    public Object getUserData() {
        return super.getUserData();
    }

    @Override
    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    @Override
    public boolean isRectangle() {
        return this.delegate.isRectangle();
    }

    @Override
    public Point getInteriorPoint() {
        return this.delegate.getInteriorPoint();
    }

    @Override
    public Geometry getEnvelope() {
        return this.delegate.getEnvelope();
    }

    @Override
    public Envelope getEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.delegate.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other) {
        return this.delegate.equalsExact(other);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equalsExact(csOther.delegate, tolerance);
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    @Override
    public boolean equals(Geometry other) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equals(csOther.delegate);
        }
        return this.linearize().equals(other);
    }

    @Override
    public boolean equalsTopo(Geometry other) {
        if (other instanceof CompoundRing) {
            CompoundRing csOther = (CompoundRing)other;
            return this.delegate.equalsTopo(csOther.delegate);
        }
        return this.linearize().equalsTopo(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            return this.equals((Geometry)o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        return this.delegate.toCurvedText();
    }

    @Override
    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    @Override
    public Point getPointN(int n) {
        if (n == 0) {
            return this.getStartPoint();
        }
        return this.linearize().getPointN(n);
    }

    @Override
    public Point getStartPoint() {
        return this.delegate.getStartPoint();
    }

    @Override
    public Point getEndPoint() {
        return this.delegate.getEndPoint();
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    @Override
    public CoordinateSequence getCoordinateSequence() {
        if (this.delegate != null) {
            return this.linearize().getCoordinateSequence();
        }
        return super.getCoordinateSequence();
    }

    @Override
    public Coordinate getCoordinateN(int n) {
        if (this.delegate != null) {
            return this.linearize().getCoordinateN(n);
        }
        return super.getCoordinateN(n);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    @Override
    public int getNumPoints() {
        if (this.delegate != null) {
            return this.linearize().getNumPoints();
        }
        return super.getNumPoints();
    }

    @Override
    public boolean isRing() {
        return this.linearize().isRing();
    }

    @Override
    public double getLength() {
        return this.linearize().getLength();
    }

    @Override
    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    @Override
    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public CompoundRing copyInternal() {
        return new CompoundRing(this.delegate);
    }

    @Override
    public void normalize() {
        this.linearize().normalize();
    }

    @Override
    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    @Override
    public boolean isValid() {
        return this.linearize().isValid();
    }

    @Override
    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    @Override
    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    @Override
    public double getArea() {
        return this.linearize().getArea();
    }

    @Override
    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    @Override
    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    @Override
    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    @Override
    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    @Override
    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    @Override
    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    @Override
    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    @Override
    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    @Override
    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    @Override
    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    @Override
    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    @Override
    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    @Override
    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    @Override
    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    @Override
    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    @Override
    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    @Override
    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    @Override
    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    @Override
    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    @Override
    public Geometry union() {
        return this.linearize().union();
    }

    @Override
    public Geometry norm() {
        return this.linearize().norm();
    }

    @Override
    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    @Override
    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    @Override
    public String toText() {
        return this.linearize().toText();
    }
}

