/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.DerivedSet;
import org.geotools.util.NameFactory;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class PropertyAuthorityFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory {
    private final Citation authority;
    private final Citation[] authorities;
    private final Properties definitions = new Properties();
    private final Set<String> codes = Collections.unmodifiableSet(this.definitions.keySet());
    private transient Map<Class<? extends IdentifiedObject>, Set<String>> filteredCodes = new HashMap<Class<? extends IdentifiedObject>, Set<String>>();
    private transient Parser parser;

    public PropertyAuthorityFactory(ReferencingFactoryContainer factories, Citation authority, URL definitions) throws IOException {
        this(factories, new Citation[]{authority}, definitions);
    }

    public PropertyAuthorityFactory(ReferencingFactoryContainer factories, Citation[] authorities, URL definitions) throws IOException {
        super(factories, 11);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        PropertyAuthorityFactory.ensureNonNull("authorities", authorities);
        if (authorities.length == 0) {
            throw new IllegalArgumentException(Errors.format(46));
        }
        this.authorities = (Citation[])authorities.clone();
        this.authority = authorities[0];
        PropertyAuthorityFactory.ensureNonNull("authority", this.authority);
        InputStream in = definitions.openStream();
        Object object = null;
        try {
            this.definitions.load(in);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        Symbols s = Symbols.DEFAULT;
        for (Object e : this.definitions.values()) {
            if (!s.containsAxis((String)e)) continue;
            LOGGER.fine("Axis elements found in a wkt definition, the force longitude first axis order hint might not be respected:\n" + e);
            return;
        }
        this.hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        if (type == null || type.isAssignableFrom(IdentifiedObject.class)) {
            return this.codes;
        }
        Map<Class<? extends IdentifiedObject>, Set<String>> map = this.filteredCodes;
        synchronized (map) {
            Codes filtered = this.filteredCodes.get(type);
            if (filtered == null) {
                Properties map2 = this.definitions;
                filtered = new Codes(map2, type);
                this.filteredCodes.put(type, filtered);
            }
            return filtered;
        }
    }

    public String getWKT(String code) throws NoSuchAuthorityCodeException {
        PropertyAuthorityFactory.ensureNonNull("code", code);
        String wkt = this.definitions.getProperty(this.trimAuthority(code));
        if (wkt == null) {
            throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        return wkt.trim();
    }

    @Override
    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        int end;
        String wkt = this.getWKT(code);
        int start = wkt.indexOf(34);
        if (start >= 0 && (end = wkt.indexOf(34, ++start)) >= 0) {
            return new SimpleInternationalString(wkt.substring(start, end).trim());
        }
        return null;
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser();
        }
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        String wkt = this.getWKT(code);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = code;
                return (IdentifiedObject)parser.parseObject(wkt);
            }
        }
        catch (ParseException exception) {
            throw new FactoryException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        String wkt = this.getWKT(code);
        Parser parser = this.getParser();
        try {
            Parser parser2 = parser;
            synchronized (parser2) {
                parser.code = code;
                return parser.parseCoordinateReferenceSystem(wkt);
            }
        }
        catch (ParseException exception) {
            throw new FactoryException(exception);
        }
    }

    @Override
    protected String trimAuthority(String code) {
        GenericName name = NameFactory.create(code = code.trim());
        GenericName scope = name.scope().name();
        if (scope == null) {
            return code;
        }
        String candidate = scope.toString();
        for (int i = 0; i < this.authorities.length; ++i) {
            if (!Citations.identifierMatches(this.authorities[i], candidate)) continue;
            return name.tip().toString().trim();
        }
        return code;
    }

    private final class Parser
    extends org.geotools.referencing.wkt.Parser {
        private static final long serialVersionUID = -5910561042299146066L;
        String code;

        public Parser() {
            super(Symbols.DEFAULT, PropertyAuthorityFactory.this.factories);
        }

        @Override
        protected Map<String, Object> alterProperties(Map<String, Object> properties) {
            Object candidate = properties.get("identifiers");
            if (candidate == null && this.code != null) {
                NamedIdentifier[] identifiers;
                properties = new HashMap<String, Object>(properties);
                this.code = PropertyAuthorityFactory.this.trimAuthority(this.code);
                if (PropertyAuthorityFactory.this.authorities.length <= 1) {
                    identifiers = new NamedIdentifier(PropertyAuthorityFactory.this.authority, this.code);
                } else {
                    NamedIdentifier[] ids = new NamedIdentifier[PropertyAuthorityFactory.this.authorities.length];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = new NamedIdentifier(PropertyAuthorityFactory.this.authorities[i], this.code);
                    }
                    identifiers = ids;
                }
                properties.put("identifiers", identifiers);
            }
            return super.alterProperties(properties);
        }
    }

    private static final class Codes
    extends DerivedSet<String, String> {
        private static final long serialVersionUID = 2681905294171687900L;
        private final Class<? extends IdentifiedObject> type;
        private final Map<String, String> definitions;

        public Codes(Map<String, String> definitions, Class<? extends IdentifiedObject> type) {
            super(definitions.keySet(), String.class);
            this.definitions = definitions;
            this.type = type;
        }

        @Override
        protected String baseToDerived(String key) {
            int i;
            String wkt = this.definitions.get(key);
            int length = wkt.length();
            for (i = 0; i < length && Character.isJavaIdentifierPart(wkt.charAt(i)); ++i) {
            }
            Class<Object> candidate = Parser.getClassOf(wkt.substring(0, i));
            if (candidate == null) {
                candidate = IdentifiedObject.class;
            }
            return this.type.isAssignableFrom(candidate) ? key : null;
        }

        @Override
        protected String derivedToBase(String element) {
            return element;
        }
    }
}

