/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo;

import java.util.Objects;
import org.ojalgo.EffectiveThrowable;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.TypeUtils;

public class ProgrammingError
extends RuntimeException
implements EffectiveThrowable {
    public static void throwForIllegalInvocation() {
        throw new ProgrammingError("Don't use this method/constructor!");
    }

    public static void throwForTryingToModifyAnImmutableObject() {
        throw new ProgrammingError("This class is immutable!");
    }

    public static void throwForUnsupportedOptionalOperation() {
        throw new UnsupportedOperationException();
    }

    public static void throwIfMultiplicationNotPossible(Access2D<?> left, Access2D<?> right) {
        if (left.countColumns() != right.countRows()) {
            throw new ProgrammingError("The column dimension of the left matrix does not match the row dimension of the right matrix!");
        }
    }

    public static void throwIfNotEqualColumnDimensions(Access2D<?> mtrx1, Access2D<?> mtrx2) {
        if (mtrx1.countColumns() != mtrx2.countColumns()) {
            throw new ProgrammingError("Column dimensions are not equal!");
        }
    }

    public static void throwIfNotEqualDimensions(Access2D<?> mtrx1, Access2D<?> mtrx2) {
        ProgrammingError.throwIfNotEqualRowDimensions(mtrx1, mtrx2);
        ProgrammingError.throwIfNotEqualColumnDimensions(mtrx1, mtrx2);
    }

    public static void throwIfNotEqualRowDimensions(Structure2D mtrx1, Structure2D mtrx2) {
        if (mtrx1.countRows() != mtrx2.countRows()) {
            throw new ProgrammingError("Row dimensions are not equal!");
        }
    }

    public static void throwIfNotSquare(Structure2D mtrx) {
        if (mtrx.countRows() != mtrx.countColumns()) {
            throw new ProgrammingError("Matrix is not square!");
        }
    }

    public static void throwIfNull(Object obj) {
        Objects.requireNonNull(obj);
    }

    public static void throwIfNull(Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            Objects.requireNonNull(objs[i]);
        }
    }

    public static void throwIfNull(Object obj1, Object obj2) {
        Objects.requireNonNull(obj1);
        Objects.requireNonNull(obj2);
    }

    public static void throwIfNull(Object obj1, Object obj2, Object obj3) {
        Objects.requireNonNull(obj1);
        Objects.requireNonNull(obj2);
        Objects.requireNonNull(obj3);
    }

    public static void throwWithMessage(String messagePattern, Object ... args) {
        throw new ProgrammingError(TypeUtils.format(messagePattern, args));
    }

    public ProgrammingError(String message) {
        super(message);
    }

    public ProgrammingError(Throwable cause) {
        super(cause);
    }

    ProgrammingError() {
    }

    ProgrammingError(String message, Throwable cause) {
        super(message, cause);
    }

    ProgrammingError(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    @Override
    public String toString() {
        String retVal = this.getClass().getSimpleName();
        String tmpMessage = this.getLocalizedMessage();
        return tmpMessage != null ? retVal + ": " + tmpMessage : retVal;
    }
}

