/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.UnaryFunction;

public interface BinaryFunction<N extends Number>
extends BasicFunction,
BinaryOperator<N>,
DoubleBinaryOperator {
    public double invoke(double var1, double var3);

    public N invoke(N var1, N var2);

    default public BinaryFunction<N> andThen(final UnaryFunction<N> after) {
        ProgrammingError.throwIfNull(after);
        return new BinaryFunction<N>(){

            @Override
            public double invoke(double arg1, double arg2) {
                return after.invoke(BinaryFunction.this.invoke(arg1, arg2));
            }

            @Override
            public N invoke(N arg1, N arg2) {
                return after.invoke(BinaryFunction.this.invoke(arg1, arg2));
            }
        };
    }

    @Override
    default public N apply(N arg1, N arg2) {
        return this.invoke(arg1, arg2);
    }

    @Override
    default public double applyAsDouble(double arg1, double arg2) {
        return this.invoke(arg1, arg2);
    }

    default public UnaryFunction<N> by(double arg2) {
        return this.second((N)arg2);
    }

    default public UnaryFunction<N> first(double arg1) {
        return new FixedFirst<double>(arg1, (BinaryFunction<double>)this);
    }

    default public UnaryFunction<N> first(N arg1) {
        return new FixedFirst<N>(arg1, this);
    }

    default public UnaryFunction<N> second(double arg2) {
        return new FixedSecond<double>((BinaryFunction<double>)this, arg2);
    }

    default public UnaryFunction<N> second(N arg2) {
        return new FixedSecond<N>(this, arg2);
    }

    public static final class FixedSecond<N extends Number>
    implements UnaryFunction<N> {
        private final BinaryFunction<N> myFunction;
        private final N myNumber;
        private final double myValue;

        FixedSecond(BinaryFunction<N> function, double arg2) {
            this.myFunction = function;
            this.myNumber = arg2;
            this.myValue = arg2;
        }

        FixedSecond(BinaryFunction<N> function, N arg2) {
            this.myFunction = function;
            this.myNumber = arg2;
            this.myValue = ((Number)arg2).doubleValue();
        }

        public final double doubleValue() {
            return this.myValue;
        }

        public final BinaryFunction<N> getFunction() {
            return this.myFunction;
        }

        public final N getNumber() {
            return this.myNumber;
        }

        @Override
        public final double invoke(double arg1) {
            return this.myFunction.invoke(arg1, this.myValue);
        }

        @Override
        public final N invoke(N arg1) {
            return this.myFunction.invoke(arg1, this.myNumber);
        }
    }

    public static final class FixedFirst<N extends Number>
    implements UnaryFunction<N> {
        private final BinaryFunction<N> myFunction;
        private final N myNumber;
        private final double myValue;

        FixedFirst(double arg1, BinaryFunction<N> function) {
            this.myFunction = function;
            this.myNumber = arg1;
            this.myValue = arg1;
        }

        FixedFirst(N arg1, BinaryFunction<N> function) {
            this.myFunction = function;
            this.myNumber = arg1;
            this.myValue = ((Number)arg1).doubleValue();
        }

        public final double doubleValue() {
            return this.myValue;
        }

        public final BinaryFunction<N> getFunction() {
            return this.myFunction;
        }

        public final N getNumber() {
            return this.myNumber;
        }

        @Override
        public final double invoke(double arg2) {
            return this.myFunction.invoke(this.myValue, arg2);
        }

        @Override
        public final N invoke(N arg2) {
            return this.myFunction.invoke(this.myNumber, arg2);
        }
    }
}

