/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.type.context.NumberContext;

public abstract class EvD2D {
    public static void hqr2(double[][] mtrxH, double[] d, double[] e, double[][] trnspV) {
        int k;
        int i;
        double y;
        double x;
        double w;
        int l;
        int j;
        int size = d.length;
        int n = size - 1;
        double exshift = PrimitiveMath.ZERO;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = PrimitiveMath.ZERO;
        for (int i2 = 0; i2 < size; ++i2) {
            for (j = Math.max(i2 - 1, 0); j < size; ++j) {
                norm += PrimitiveFunction.ABS.invoke(mtrxH[i2][j]);
            }
        }
        int iter = 0;
        while (n >= 0) {
            int m;
            int i3;
            for (l = n; l > 0; --l) {
                s = PrimitiveFunction.ABS.invoke(mtrxH[l - 1][l - 1]) + PrimitiveFunction.ABS.invoke(mtrxH[l][l]);
                if (NumberContext.compare(s, PrimitiveMath.ZERO) == 0) {
                    s = norm;
                }
                if (PrimitiveFunction.ABS.invoke(mtrxH[l][l - 1]) < PrimitiveMath.MACHINE_EPSILON * s) break;
            }
            if (l == n) {
                mtrxH[n][n] = mtrxH[n][n] + exshift;
                d[n] = mtrxH[n][n];
                e[n] = PrimitiveMath.ZERO;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = mtrxH[n][n - 1] * mtrxH[n - 1][n];
                p = (mtrxH[n - 1][n - 1] - mtrxH[n][n]) / PrimitiveMath.TWO;
                q = p * p + w;
                z = PrimitiveFunction.SQRT.invoke(PrimitiveFunction.ABS.invoke(q));
                mtrxH[n][n] = mtrxH[n][n] + exshift;
                mtrxH[n - 1][n - 1] = mtrxH[n - 1][n - 1] + exshift;
                x = mtrxH[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    d[n - 1] = x + z;
                    d[n] = d[n - 1];
                    if (NumberContext.compare(z, PrimitiveMath.ZERO) != 0) {
                        d[n] = x - w / z;
                    }
                    e[n - 1] = PrimitiveMath.ZERO;
                    e[n] = PrimitiveMath.ZERO;
                    x = mtrxH[n][n - 1];
                    s = PrimitiveFunction.ABS.invoke(x) + PrimitiveFunction.ABS.invoke(z);
                    p = x / s;
                    q = z / s;
                    r = PrimitiveFunction.SQRT.invoke(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j2 = n - 1; j2 < size; ++j2) {
                        z = mtrxH[n - 1][j2];
                        mtrxH[n - 1][j2] = q * z + p * mtrxH[n][j2];
                        mtrxH[n][j2] = q * mtrxH[n][j2] - p * z;
                    }
                    for (i3 = 0; i3 <= n; ++i3) {
                        z = mtrxH[i3][n - 1];
                        mtrxH[i3][n - 1] = q * z + p * mtrxH[i3][n];
                        mtrxH[i3][n] = q * mtrxH[i3][n] - p * z;
                    }
                    if (trnspV != null) {
                        for (i3 = 0; i3 <= size - 1; ++i3) {
                            z = trnspV[n - 1][i3];
                            trnspV[n - 1][i3] = q * z + p * trnspV[n][i3];
                            trnspV[n][i3] = q * trnspV[n][i3] - p * z;
                        }
                    }
                } else {
                    d[n - 1] = x + p;
                    d[n] = x + p;
                    e[n - 1] = z;
                    e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = mtrxH[n][n];
            y = mtrxH[n - 1][n - 1];
            w = mtrxH[n][n - 1] * mtrxH[n - 1][n];
            if (iter == 10) {
                exshift += x;
                i3 = 0;
                while (i3 <= n) {
                    double[] dArray = mtrxH[i3];
                    int n2 = i3++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = PrimitiveFunction.ABS.invoke(mtrxH[n][n - 1]) + PrimitiveFunction.ABS.invoke(mtrxH[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / PrimitiveMath.TWO;
                if ((s = s * s + w) > 0.0) {
                    s = PrimitiveFunction.SQRT.invoke(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / PrimitiveMath.TWO + s);
                    i3 = 0;
                    while (i3 <= n) {
                        double[] dArray = mtrxH[i3];
                        int n3 = i3++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = mtrxH[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / mtrxH[m + 1][m] + mtrxH[m][m + 1];
                q = mtrxH[m + 1][m + 1] - z - r - s;
                r = mtrxH[m + 2][m + 1];
                s = PrimitiveFunction.ABS.invoke(p) + PrimitiveFunction.ABS.invoke(q) + PrimitiveFunction.ABS.invoke(r);
                if (m == l || PrimitiveFunction.ABS.invoke(mtrxH[m][m - 1]) * (PrimitiveFunction.ABS.invoke(q /= s) + PrimitiveFunction.ABS.invoke(r /= s)) < PrimitiveMath.MACHINE_EPSILON * (PrimitiveFunction.ABS.invoke(p /= s) * (PrimitiveFunction.ABS.invoke(mtrxH[m - 1][m - 1]) + PrimitiveFunction.ABS.invoke(z) + PrimitiveFunction.ABS.invoke(mtrxH[m + 1][m + 1])))) break;
            }
            for (i = m + 2; i <= n; ++i) {
                mtrxH[i][i - 2] = PrimitiveMath.ZERO;
                if (i <= m + 2) continue;
                mtrxH[i][i - 3] = PrimitiveMath.ZERO;
            }
            for (k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = mtrxH[k][k - 1];
                    q = mtrxH[k + 1][k - 1];
                    r = notlast ? mtrxH[k + 2][k - 1] : PrimitiveMath.ZERO;
                    x = PrimitiveFunction.ABS.invoke(p) + PrimitiveFunction.ABS.invoke(q) + PrimitiveFunction.ABS.invoke(r);
                    if (NumberContext.compare(x, PrimitiveMath.ZERO) == 0) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = PrimitiveFunction.SQRT.invoke(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    mtrxH[k][k - 1] = -s * x;
                } else if (l != m) {
                    mtrxH[k][k - 1] = -mtrxH[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < size; ++j3) {
                    p = mtrxH[k][j3] + q * mtrxH[k + 1][j3];
                    if (notlast) {
                        mtrxH[k + 2][j3] = mtrxH[k + 2][j3] - (p += r * mtrxH[k + 2][j3]) * z;
                    }
                    mtrxH[k][j3] = mtrxH[k][j3] - p * x;
                    mtrxH[k + 1][j3] = mtrxH[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * mtrxH[i4][k] + y * mtrxH[i4][k + 1];
                    if (notlast) {
                        mtrxH[i4][k + 2] = mtrxH[i4][k + 2] - (p += z * mtrxH[i4][k + 2]) * r;
                    }
                    mtrxH[i4][k] = mtrxH[i4][k] - p;
                    mtrxH[i4][k + 1] = mtrxH[i4][k + 1] - p * q;
                }
                if (trnspV == null) continue;
                for (i4 = 0; i4 <= size - 1; ++i4) {
                    p = x * trnspV[k][i4] + y * trnspV[k + 1][i4];
                    if (notlast) {
                        trnspV[k + 2][i4] = trnspV[k + 2][i4] - (p += z * trnspV[k + 2][i4]) * r;
                    }
                    trnspV[k][i4] = trnspV[k][i4] - p;
                    trnspV[k + 1][i4] = trnspV[k + 1][i4] - p * q;
                }
            }
        }
        if (NumberContext.compare(norm, PrimitiveMath.ZERO) == 0) {
            return;
        }
        for (n = size - 1; n >= 0; --n) {
            double t;
            p = d[n];
            q = e[n];
            if (q == 0.0) {
                l = n;
                mtrxH[n][n] = PrimitiveMath.ONE;
                for (int i5 = n - 1; i5 >= 0; --i5) {
                    int j4;
                    w = mtrxH[i5][i5] - p;
                    r = PrimitiveMath.ZERO;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += mtrxH[i5][j4] * mtrxH[j4][n];
                    }
                    if (e[i5] < PrimitiveMath.ZERO) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i5;
                    if (e[i5] == PrimitiveMath.ZERO) {
                        mtrxH[i5][n] = NumberContext.compare(w, PrimitiveMath.ZERO) != 0 ? -r / w : -r / (PrimitiveMath.MACHINE_EPSILON * norm);
                    } else {
                        x = mtrxH[i5][i5 + 1];
                        y = mtrxH[i5 + 1][i5];
                        q = (d[i5] - p) * (d[i5] - p) + e[i5] * e[i5];
                        mtrxH[i5][n] = t = (x * s - z * r) / q;
                        mtrxH[i5 + 1][n] = PrimitiveFunction.ABS.invoke(x) > PrimitiveFunction.ABS.invoke(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = PrimitiveFunction.ABS.invoke(mtrxH[i5][n]);
                    if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                    for (j4 = i5; j4 <= n; ++j4) {
                        mtrxH[j4][n] = mtrxH[j4][n] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            double[] cdiv = new double[2];
            if (PrimitiveFunction.ABS.invoke(mtrxH[n][n - 1]) > PrimitiveFunction.ABS.invoke(mtrxH[n - 1][n])) {
                mtrxH[n - 1][n - 1] = q / mtrxH[n][n - 1];
                mtrxH[n - 1][n] = -(mtrxH[n][n] - p) / mtrxH[n][n - 1];
            } else {
                EvD2D.cdiv(PrimitiveMath.ZERO, -mtrxH[n - 1][n], mtrxH[n - 1][n - 1] - p, q, cdiv);
                mtrxH[n - 1][n - 1] = cdiv[0];
                mtrxH[n - 1][n] = cdiv[1];
            }
            mtrxH[n][n - 1] = PrimitiveMath.ZERO;
            mtrxH[n][n] = PrimitiveMath.ONE;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = PrimitiveMath.ZERO;
                double sa = PrimitiveMath.ZERO;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += mtrxH[i][j5] * mtrxH[j5][n - 1];
                    sa += mtrxH[i][j5] * mtrxH[j5][n];
                }
                w = mtrxH[i][i] - p;
                if (e[i] < PrimitiveMath.ZERO) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (e[i] == 0.0) {
                    EvD2D.cdiv(-ra, -sa, w, q, cdiv);
                    mtrxH[i][n - 1] = cdiv[0];
                    mtrxH[i][n] = cdiv[1];
                } else {
                    x = mtrxH[i][i + 1];
                    y = mtrxH[i + 1][i];
                    double vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
                    double vi = (d[i] - p) * PrimitiveMath.TWO * q;
                    if (NumberContext.compare(vr, PrimitiveMath.ZERO) == 0 && NumberContext.compare(vi, PrimitiveMath.ZERO) == 0) {
                        vr = PrimitiveMath.MACHINE_EPSILON * norm * (PrimitiveFunction.ABS.invoke(w) + PrimitiveFunction.ABS.invoke(q) + PrimitiveFunction.ABS.invoke(x) + PrimitiveFunction.ABS.invoke(y) + PrimitiveFunction.ABS.invoke(z));
                    }
                    EvD2D.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi, cdiv);
                    mtrxH[i][n - 1] = cdiv[0];
                    mtrxH[i][n] = cdiv[1];
                    if (PrimitiveFunction.ABS.invoke(x) > PrimitiveFunction.ABS.invoke(z) + PrimitiveFunction.ABS.invoke(q)) {
                        mtrxH[i + 1][n - 1] = (-ra - w * mtrxH[i][n - 1] + q * mtrxH[i][n]) / x;
                        mtrxH[i + 1][n] = (-sa - w * mtrxH[i][n] - q * mtrxH[i][n - 1]) / x;
                    } else {
                        EvD2D.cdiv(-r - y * mtrxH[i][n - 1], -s - y * mtrxH[i][n], z, q, cdiv);
                        mtrxH[i + 1][n - 1] = cdiv[0];
                        mtrxH[i + 1][n] = cdiv[1];
                    }
                }
                t = PrimitiveFunction.MAX.invoke(PrimitiveFunction.ABS.invoke(mtrxH[i][n - 1]), PrimitiveFunction.ABS.invoke(mtrxH[i][n]));
                if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    mtrxH[j5][n - 1] = mtrxH[j5][n - 1] / t;
                    mtrxH[j5][n] = mtrxH[j5][n] / t;
                }
            }
        }
        if (trnspV != null) {
            for (j = size - 1; j >= 0; --j) {
                for (int i6 = 0; i6 <= size - 1; ++i6) {
                    z = PrimitiveMath.ZERO;
                    for (k = 0; k <= Math.min(j, size - 1); ++k) {
                        z += trnspV[k][i6] * mtrxH[k][j];
                    }
                    trnspV[j][i6] = z;
                }
            }
        }
    }

    public static void orthes(double[][] mtrxH, double[][] trnspV, double[] vctrWork) {
        int i;
        int m;
        int size = vctrWork.length;
        int sizeM1 = size - 1;
        int sizeM2 = size - 2;
        for (m = 1; m <= sizeM2; ++m) {
            double f;
            int ij = m - 1;
            double scale = PrimitiveMath.ZERO;
            for (i = m; i <= sizeM1; ++i) {
                scale += PrimitiveFunction.ABS.invoke(mtrxH[i][ij]);
            }
            if (NumberContext.compare(scale, PrimitiveMath.ZERO) == 0) continue;
            double h = PrimitiveMath.ZERO;
            for (int i2 = sizeM1; i2 >= m; --i2) {
                vctrWork[i2] = mtrxH[i2][ij] / scale;
                h += vctrWork[i2] * vctrWork[i2];
            }
            double g = PrimitiveFunction.SQRT.invoke(h);
            if (vctrWork[m] > 0.0) {
                g = -g;
            }
            h -= vctrWork[m] * g;
            vctrWork[m] = vctrWork[m] - g;
            for (int j = m; j < size; ++j) {
                int i3;
                f = PrimitiveMath.ZERO;
                for (i3 = sizeM1; i3 >= m; --i3) {
                    f += vctrWork[i3] * mtrxH[i3][j];
                }
                f /= h;
                for (i3 = m; i3 <= sizeM1; ++i3) {
                    double[] dArray = mtrxH[i3];
                    int n = j;
                    dArray[n] = dArray[n] - f * vctrWork[i3];
                }
            }
            for (int i4 = 0; i4 <= sizeM1; ++i4) {
                int j;
                f = PrimitiveMath.ZERO;
                for (j = sizeM1; j >= m; --j) {
                    f += vctrWork[j] * mtrxH[i4][j];
                }
                f /= h;
                for (j = m; j <= sizeM1; ++j) {
                    double[] dArray = mtrxH[i4];
                    int n = j;
                    dArray[n] = dArray[n] - f * vctrWork[j];
                }
            }
            vctrWork[m] = scale * vctrWork[m];
            mtrxH[m][ij] = scale * g;
        }
        if (trnspV != null) {
            int j;
            for (int i5 = 0; i5 < size; ++i5) {
                for (j = 0; j < size; ++j) {
                    trnspV[j][i5] = i5 == j ? PrimitiveMath.ONE : PrimitiveMath.ZERO;
                }
            }
            for (m = sizeM2; m >= 1; --m) {
                if (mtrxH[m][m - 1] == PrimitiveMath.ZERO) continue;
                for (int i6 = m + 1; i6 <= sizeM1; ++i6) {
                    vctrWork[i6] = mtrxH[i6][m - 1];
                }
                for (j = m; j <= sizeM1; ++j) {
                    double g = PrimitiveMath.ZERO;
                    for (i = m; i <= sizeM1; ++i) {
                        g += vctrWork[i] * trnspV[j][i];
                    }
                    g = g / vctrWork[m] / mtrxH[m][m - 1];
                    for (i = m; i <= sizeM1; ++i) {
                        double[] dArray = trnspV[j];
                        int n = i;
                        dArray[n] = dArray[n] + g * vctrWork[i];
                    }
                }
            }
        }
    }

    private static void cdiv(double xr, double xi, double yr, double yi, double[] cdiv) {
        if (PrimitiveFunction.ABS.invoke(yr) > PrimitiveFunction.ABS.invoke(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            cdiv[0] = (xr + r * xi) / d;
            cdiv[1] = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            cdiv[0] = (r * xr + xi) / d;
            cdiv[1] = (r * xi - xr) / d;
        }
    }
}

