/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access1D;

abstract class MatrixPipeline<N extends Number>
implements ElementsSupplier<N> {
    private final ElementsSupplier<N> myContext;

    protected MatrixPipeline(ElementsSupplier<N> context) {
        this.myContext = context;
    }

    @Override
    public long countColumns() {
        return this.myContext.countColumns();
    }

    @Override
    public long countRows() {
        return this.myContext.countRows();
    }

    @Override
    public final PhysicalStore.Factory<N, ?> physical() {
        return this.myContext.physical();
    }

    public String toString() {
        return this.myContext.toString();
    }

    ElementsSupplier<N> getContext() {
        return this.myContext;
    }

    static final class UnaryOperator<N extends Number>
    extends MatrixPipeline<N> {
        private final UnaryFunction<N> myOperator;

        UnaryOperator(ElementsSupplier<N> context, UnaryFunction<N> operator) {
            super(context);
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyAll(this.myOperator);
        }
    }

    static final class Transpose<N extends Number>
    extends MatrixPipeline<N> {
        Transpose(ElementsSupplier<N> context) {
            super(context);
        }

        @Override
        public long countColumns() {
            return this.getContext().countRows();
        }

        @Override
        public long countRows() {
            return this.getContext().countColumns();
        }

        @Override
        public MatrixStore<N> get() {
            PhysicalStore retVal = (PhysicalStore)this.physical().makeZero(this.getContext().countRows(), this.getContext().countColumns());
            this.supplyTo(retVal);
            return retVal;
        }

        @Override
        public ElementsSupplier<N> operateOnAll(UnaryFunction<N> operator) {
            return this.getContext().operateOnAll((UnaryFunction)operator);
        }

        @Override
        public ElementsSupplier<N> operateOnMatching(BinaryFunction<N> operator, MatrixStore<N> right) {
            return this.getContext().operateOnMatching(operator, (MatrixStore<N>)right.transpose());
        }

        @Override
        public ElementsSupplier<N> operateOnMatching(MatrixStore<N> left, BinaryFunction<N> operator) {
            return this.getContext().operateOnMatching((MatrixStore<N>)left.transpose(), operator);
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.getContext().supplyTo(receiver.regionByTransposing());
        }

        @Override
        public ElementsSupplier<N> transpose() {
            return this.getContext();
        }
    }

    static final class RowsReducer<N extends Number>
    extends MatrixPipeline<N> {
        private final Aggregator myAggregator;
        private final MatrixStore<N> myBase;

        RowsReducer(MatrixStore<N> base, Aggregator aggregator) {
            super(base);
            this.myBase = base;
            this.myAggregator = aggregator;
        }

        @Override
        public long countColumns() {
            return 1L;
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.myBase.reduceRows(this.myAggregator, receiver);
        }
    }

    static final class Multiplication<N extends Number>
    extends MatrixPipeline<N> {
        private final Access1D<N> myLeft;
        private final MatrixStore<N> myRight;

        Multiplication(Access1D<N> left, MatrixStore<N> right) {
            super(right);
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public long countColumns() {
            return this.myRight.countColumns();
        }

        @Override
        public long countRows() {
            return this.myLeft.count() / this.myRight.countRows();
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            receiver.fillByMultiplying(this.myLeft, this.myRight);
        }
    }

    static final class ColumnsReducer<N extends Number>
    extends MatrixPipeline<N> {
        private final Aggregator myAggregator;
        private final MatrixStore<N> myBase;

        ColumnsReducer(MatrixStore<N> base, Aggregator aggregator) {
            super(base);
            this.myBase = base;
            this.myAggregator = aggregator;
        }

        @Override
        public long countRows() {
            return 1L;
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.myBase.reduceColumns(this.myAggregator, receiver);
        }
    }

    static final class BinaryOperatorRight<N extends Number>
    extends MatrixPipeline<N> {
        private final BinaryFunction<N> myOperator;
        private final MatrixStore<N> myRight;

        BinaryOperatorRight(ElementsSupplier<N> left, BinaryFunction<N> operator, MatrixStore<N> right) {
            super(left);
            this.myRight = right;
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyMatching(this.myOperator, this.myRight);
        }
    }

    static final class BinaryOperatorLeft<N extends Number>
    extends MatrixPipeline<N> {
        private final MatrixStore<N> myLeft;
        private final BinaryFunction<N> myOperator;

        BinaryOperatorLeft(MatrixStore<N> left, BinaryFunction<N> operator, ElementsSupplier<N> right) {
            super(right);
            this.myLeft = left;
            this.myOperator = operator;
        }

        @Override
        public void supplyTo(ElementsConsumer<N> receiver) {
            this.getContext().supplyTo(receiver);
            receiver.modifyMatching(this.myLeft, this.myOperator);
        }
    }
}

