/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public final class GenerateApplyAndCopyHouseholderRow
extends MatrixOperation {
    public static final GenerateApplyAndCopyHouseholderRow SETUP = new GenerateApplyAndCopyHouseholderRow();
    public static int THRESHOLD = 128;

    public static boolean invoke(double[] data, int structure, int row, int col, Householder.Primitive destination) {
        int tmpColDim = data.length / structure;
        double[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = PrimitiveFunction.MAX.invoke(tmpNormInf, PrimitiveFunction.ABS.invoke(tmpVector[j]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int j = col + 1;
            while (j < tmpColDim) {
                int n = j++;
                double d = tmpVector[n] / tmpNormInf;
                tmpVector[n] = d;
                double tmpVal = d;
                tmpNorm2 += tmpVal * tmpVal;
            }
            double value = tmpNorm2;
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, value);
        }
        if (retVal) {
            double tmpScale = tmpVector[col] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = PrimitiveFunction.SQRT.invoke(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + col * structure] = tmpNorm2 * tmpNormInf;
                tmpScale -= tmpNorm2;
            } else {
                data[row + col * structure] = -tmpNorm2 * tmpNormInf;
                tmpScale += tmpNorm2;
            }
            tmpVector[col] = PrimitiveMath.ONE;
            for (int j = col + 1; j < tmpColDim; ++j) {
                int n = j;
                double d = tmpVector[n] / tmpScale;
                tmpVector[n] = d;
                data[row + j * structure] = d;
            }
            destination.beta = PrimitiveFunction.ABS.invoke(tmpScale) / tmpNorm2;
        }
        return retVal;
    }

    public static <N extends Number> boolean invoke(N[] data, int structure, int row, int col, Householder.Generic<N> destination, Scalar.Factory<N> scalar) {
        int tmpColDim = data.length / structure;
        N[] tmpVector = destination.vector;
        destination.first = col;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int j = col; j < tmpColDim; ++j) {
            tmpVector[j] = data[row + j * structure];
            tmpNormInf = PrimitiveFunction.MAX.invoke(tmpNormInf, ((NormedVectorSpace)tmpVector[j]).norm());
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            for (int j = col + 1; j < tmpColDim; ++j) {
                Object tmpVal = ((Scalar)((ScalarOperation.Division)tmpVector[j]).divide(tmpNormInf)).get();
                tmpNorm2 += ((NormedVectorSpace)tmpVal).norm() * ((NormedVectorSpace)tmpVal).norm();
                tmpVector[j] = tmpVal;
            }
            double value = tmpNorm2;
            boolean bl = retVal = !PrimitiveScalar.isSmall(PrimitiveMath.ONE, value);
        }
        if (retVal) {
            Object tmpScale = ((Scalar)((ScalarOperation.Division)tmpVector[col]).divide(tmpNormInf)).get();
            tmpNorm2 += ((NormedVectorSpace)tmpScale).norm() * ((NormedVectorSpace)tmpScale).norm();
            tmpNorm2 = PrimitiveFunction.SQRT.invoke(tmpNorm2);
            data[row + col * structure] = ((Scalar)((Scalar)((NormedVectorSpace)tmpScale).signum()).multiply(tmpNorm2 * tmpNormInf)).get();
            tmpScale = ((Scalar)tmpScale).subtract((Scalar)((Scalar)((NormedVectorSpace)tmpScale).signum()).multiply(tmpNorm2)).get();
            tmpVector[col] = scalar.one().get();
            for (int j = col + 1; j < tmpColDim; ++j) {
                tmpVector[j] = ((Scalar)((Scalar)((ScalarOperation.Division)tmpVector[j]).divide(tmpScale)).conjugate()).get();
                data[row + j * structure] = tmpVector[j];
            }
            destination.beta = scalar.cast(((NormedVectorSpace)tmpScale).norm() / tmpNorm2);
        }
        return retVal;
    }

    private GenerateApplyAndCopyHouseholderRow() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

