/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class MultiplyHermitianAndVector
extends MatrixOperation {
    public static final MultiplyHermitianAndVector SETUP = new MultiplyHermitianAndVector();
    public static int THRESHOLD = 256;

    public static void invoke(double[] productMatrix, int firstRow, int rowLimit, double[] hermitianMatrix, double[] rightVector, int firstColumn) {
        int structure = rightVector.length;
        for (int i = firstRow; i < rowLimit; ++i) {
            int c;
            double tmpVal = PrimitiveMath.ZERO;
            for (c = firstColumn; c < i; ++c) {
                tmpVal += hermitianMatrix[i + c * structure] * rightVector[c];
            }
            for (c = i; c < structure; ++c) {
                tmpVal += hermitianMatrix[c + i * structure] * rightVector[c];
            }
            productMatrix[i] = tmpVal;
        }
    }

    public static <N extends Number> void invoke(N[] productMatrix, int firstRow, int rowLimit, N[] hermitianMatrix, N[] rightVector, int firstColumn, Scalar.Factory<N> scalar) {
        int structure = rightVector.length;
        for (int i = firstRow; i < rowLimit; ++i) {
            int c;
            Scalar<N> tmpVal = scalar.zero();
            for (c = firstColumn; c < i; ++c) {
                tmpVal = tmpVal.add((Scalar)((ScalarOperation.Multiplication)hermitianMatrix[i + c * structure]).multiply(rightVector[c]));
            }
            for (c = i; c < structure; ++c) {
                tmpVal = tmpVal.add((Scalar)((Scalar)((VectorSpace)hermitianMatrix[c + i * structure]).conjugate()).multiply(rightVector[c]));
            }
            productMatrix[i] = tmpVal.get();
        }
    }

    private MultiplyHermitianAndVector() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

