/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

public interface Access1D<N extends Number>
extends Structure1D {
    public static Access1D<Double> asPrimitive1D(final Access1D<?> access) {
        return new Access1D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }
        };
    }

    public static boolean equals(Access1D<?> accessA, Access1D<?> accessB, NumberContext context) {
        boolean retVal;
        long tmpLength = accessA.count();
        boolean bl = retVal = tmpLength == accessB.count();
        if (accessA.get(0L) instanceof ComplexNumber && accessB.get(0L) instanceof ComplexNumber) {
            Access1D<?> tmpAccessA = accessA;
            Access1D<?> tmpAccessB = accessB;
            int i = 0;
            while (retVal && (long)i < tmpLength) {
                retVal &= !context.isDifferent(((ComplexNumber)tmpAccessA.get(i)).getReal(), ((ComplexNumber)tmpAccessB.get(i)).getReal());
                retVal &= !context.isDifferent(((ComplexNumber)tmpAccessA.get((long)((long)i))).i, ((ComplexNumber)tmpAccessB.get((long)((long)i))).i);
                ++i;
            }
        } else {
            int i = 0;
            while (retVal && (long)i < tmpLength) {
                retVal &= !context.isDifferent(accessA.doubleValue(i), accessB.doubleValue(i));
                ++i;
            }
        }
        return retVal;
    }

    public static int hashCode(Access1D<?> access) {
        int tmpSize = (int)access.count();
        int retVal = tmpSize + 31;
        for (int ij = 0; ij < tmpSize; ++ij) {
            retVal = (int)((double)retVal * access.doubleValue(ij));
        }
        return retVal;
    }

    public static Access1D<Double> wrap(final double[] target) {
        return new Access1D<Double>(){

            @Override
            public long count() {
                return target.length;
            }

            @Override
            public double doubleValue(long index) {
                return target[(int)index];
            }

            @Override
            public Double get(long index) {
                return target[(int)index];
            }
        };
    }

    public static <N extends Number> Access1D<N> wrap(final List<? extends N> target) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return target.size();
            }

            @Override
            public double doubleValue(long index) {
                return ((Number)target.get((int)index)).doubleValue();
            }

            @Override
            public N get(long index) {
                return (Number)target.get((int)index);
            }
        };
    }

    public static <N extends Number> Access1D<N> wrap(N[] target) {
        return new Access1D<N>((Number[])target){
            final /* synthetic */ Number[] val$target;
            {
                this.val$target = numberArray;
            }

            @Override
            public long count() {
                return this.val$target.length;
            }

            @Override
            public double doubleValue(long index) {
                return this.val$target[(int)index].doubleValue();
            }

            @Override
            public N get(long index) {
                return this.val$target[(int)index];
            }
        };
    }

    @Deprecated
    public static Access1D<Double> wrapAccess1D(double[] target) {
        return Access1D.wrap(target);
    }

    @Deprecated
    public static <N extends Number> Access1D<N> wrapAccess1D(List<? extends N> target) {
        return Access1D.wrap(target);
    }

    @Deprecated
    public static <N extends Number> Access1D<N> wrapAccess1D(N[] target) {
        return Access1D.wrap(target);
    }

    default public <NN extends Number, R extends Mutate1D.Receiver<NN>> Collectable<NN, R> asCollectable1D() {
        return new Collectable<NN, R>(){

            @Override
            public long count() {
                return Access1D.this.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access1D.this);
            }
        };
    }

    default public void axpy(double a, Mutate1D y) {
        Structure1D.loopMatching(this, y, i -> y.add(i, a * this.doubleValue(i)));
    }

    default public byte byteValue(long index) {
        return (byte)this.shortValue(index);
    }

    default public double dot(Access1D<?> vector) {
        DoubleAdder retVal = new DoubleAdder();
        Structure1D.loopMatching(this, vector, i -> retVal.add(this.doubleValue(i) * vector.doubleValue(i)));
        return retVal.doubleValue();
    }

    public double doubleValue(long var1);

    default public ElementView1D<N, ?> elements() {
        return new ElementView(this);
    }

    default public float floatValue(long index) {
        return (float)this.doubleValue(index);
    }

    public N get(long var1);

    default public int intValue(long index) {
        return (int)this.longValue(index);
    }

    default public long longValue(long index) {
        return Math.round(this.doubleValue(index));
    }

    default public ElementView1D<N, ?> nonzeros() {
        return this.elements();
    }

    default public short shortValue(long index) {
        return (short)this.intValue(index);
    }

    default public void supplyTo(double[] receiver) {
        int limit = Math.min(receiver.length, (int)this.count());
        for (int i = 0; i < limit; ++i) {
            receiver[i] = this.doubleValue(i);
        }
    }

    default public double[] toRawCopy1D() {
        int tmpLength = (int)this.count();
        double[] retVal = new double[tmpLength];
        this.supplyTo(retVal);
        return retVal;
    }

    public static interface Visitable<N extends Number>
    extends Structure1D {
        default public void visitAll(VoidFunction<N> visitor) {
            this.visitRange(0L, this.count(), visitor);
        }

        public void visitOne(long var1, VoidFunction<N> var3);

        default public void visitRange(long first, long limit, VoidFunction<N> visitor) {
            Structure1D.loopRange(first, limit, i -> this.visitOne(i, visitor));
        }
    }

    public static interface Sliceable<N extends Number>
    extends Structure1D {
        public Access1D<N> sliceRange(long var1, long var3);
    }

    public static interface IndexOf
    extends Structure1D {
        default public long indexOfLargest() {
            return this.indexOfLargestInRange(0L, this.count());
        }

        public long indexOfLargestInRange(long var1, long var3);
    }

    public static final class ElementView<N extends Number>
    implements ElementView1D<N, ElementView<N>> {
        private long myCursor;
        private final long myLastCursor;
        private final Access1D<N> myValues;

        private ElementView(Access1D<N> values, long initial, long last) {
            this.myValues = values;
            this.myCursor = initial;
            this.myLastCursor = last;
        }

        ElementView(Access1D<N> values) {
            this(values, -1L, values.count() - 1L);
        }

        @Override
        public double doubleValue() {
            return this.myValues.doubleValue(this.myCursor);
        }

        @Override
        public long estimateSize() {
            return this.myLastCursor - this.myCursor;
        }

        @Override
        public N get() {
            return this.myValues.get(this.myCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.myLastCursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0L;
        }

        @Override
        public long index() {
            return this.myCursor;
        }

        @Override
        public ElementView<N> iterator() {
            return new ElementView<N>(this.myValues);
        }

        @Override
        public ElementView<N> next() {
            ++this.myCursor;
            return this;
        }

        @Override
        public ElementView<N> previous() {
            --this.myCursor;
            return this;
        }

        @Override
        public ElementView<N> trySplit() {
            long remaining = this.myLastCursor - this.myCursor;
            if (remaining > 1L) {
                long split = this.myCursor + remaining / 2L;
                ElementView<N> retVal = new ElementView<N>(this.myValues, this.myCursor, split);
                this.myCursor = split;
                return retVal;
            }
            return null;
        }
    }

    public static interface Elements
    extends Structure1D {
        public boolean isAbsolute(long var1);

        default public boolean isAllSmall(double comparedTo) {
            boolean retVal = true;
            long tmpLimit = this.count();
            for (long i = 0L; retVal && i < tmpLimit; retVal &= this.isSmall(i, comparedTo), ++i) {
            }
            return retVal;
        }

        public boolean isSmall(long var1, double var3);
    }

    public static interface Collectable<N extends Number, R extends Mutate1D.Receiver<N>>
    extends Structure1D {
        default public <I extends R> I collect(Factory1D<I> factory) {
            Mutate1D.Receiver retVal = (Mutate1D.Receiver)factory.makeZero(this.count());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Number>
    extends Structure1D {
        default public N aggregateAll(Aggregator aggregator) {
            return this.aggregateRange(0L, this.count(), aggregator);
        }

        public N aggregateRange(long var1, long var3, Aggregator var5);
    }
}

