/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.shortestpath;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.algorithms.shortestpath.OneToOneShortestPathAlgorithm;
import org.planit.algorithms.shortestpath.ShortestPathResult;
import org.planit.geo.PlanitJtsUtils;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.Idable;
import org.planit.utils.misc.Pair;

public class AStarShortestPathAlgorithm
implements OneToOneShortestPathAlgorithm {
    protected final double[] edgeSegmentCosts;
    protected final int numberOfEdgeSegments;
    protected final int numberOfVertices;
    protected final PlanitJtsUtils geoUtils;
    protected final double heuristicDistanceMultiplier;
    protected static final Comparator<Pair<DirectedVertex, Double>> pairSecondComparator = Comparator.comparing(Pair::second, (f1, f2) -> f1.compareTo((Double)f2));

    public AStarShortestPathAlgorithm(double[] edgeSegmentCosts, int numberOfVertices, CoordinateReferenceSystem crs, double heuristicDistanceMultiplier) {
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numberOfVertices = numberOfVertices;
        this.numberOfEdgeSegments = edgeSegmentCosts.length;
        this.geoUtils = new PlanitJtsUtils(crs);
        this.heuristicDistanceMultiplier = heuristicDistanceMultiplier;
    }

    @Override
    public ShortestPathResult executeOneToOne(DirectedVertex origin, DirectedVertex destination) throws PlanItException {
        Pair<DirectedVertex, Double> cheapestNextVertex;
        int vertexId;
        if (origin.getPosition() == null || destination.getPosition() == null) {
            throw new PlanItException("aStar shortest path must compute distances between vertices on-the-fly. One or more vertices do not have location information available making this impossible");
        }
        double[] vertexMeasuredCost = new double[this.numberOfVertices];
        Arrays.fill(vertexMeasuredCost, Double.POSITIVE_INFINITY);
        double[] vertexHeuristicCost = new double[this.numberOfVertices];
        Arrays.fill(vertexHeuristicCost, Double.POSITIVE_INFINITY);
        EdgeSegment[] incomingEdgeSegment = new EdgeSegment[this.numberOfVertices];
        boolean[] closedVertex = new boolean[this.numberOfVertices];
        Arrays.fill(closedVertex, Boolean.FALSE);
        PriorityQueue<Pair<DirectedVertex, Double>> openVertices = new PriorityQueue<Pair<DirectedVertex, Double>>(this.numberOfVertices, pairSecondComparator);
        openVertices.add(Pair.create(origin, 0.0));
        vertexMeasuredCost[(int)origin.getId()] = 0.0;
        vertexHeuristicCost[(int)origin.getId()] = this.geoUtils.getDistanceInKilometres(origin.getPosition(), destination.getPosition()) * this.heuristicDistanceMultiplier;
        incomingEdgeSegment[(int)origin.getId()] = null;
        Idable currentVertex = null;
        while (!openVertices.isEmpty() && (long)(vertexId = (int)(currentVertex = (cheapestNextVertex = openVertices.poll()).first()).getId()) != destination.getId()) {
            if (closedVertex[vertexId]) continue;
            closedVertex[vertexId] = true;
            double costToVertex = vertexMeasuredCost[vertexId];
            for (EdgeSegment adjacentEdgeSegment : currentVertex.getExitEdgeSegments()) {
                int adjacentVertexId = (int)adjacentEdgeSegment.getDownstreamVertex().getId();
                double exitEdgeCost = this.edgeSegmentCosts[(int)adjacentEdgeSegment.getId()];
                if (!(exitEdgeCost < Double.POSITIVE_INFINITY)) continue;
                double tentativeCost = costToVertex + exitEdgeCost;
                DirectedVertex adjacentVertex = adjacentEdgeSegment.getDownstreamVertex();
                double adjacentMeasuredCost = vertexMeasuredCost[adjacentVertexId];
                if (adjacentMeasuredCost == Double.POSITIVE_INFINITY) {
                    vertexHeuristicCost[adjacentVertexId] = this.geoUtils.getDistanceInKilometres(adjacentVertex.getPosition(), destination.getPosition()) * this.heuristicDistanceMultiplier;
                }
                if (!(adjacentMeasuredCost > tentativeCost)) continue;
                incomingEdgeSegment[adjacentVertexId] = adjacentEdgeSegment;
                vertexMeasuredCost[adjacentVertexId] = tentativeCost;
                double priorityCost = tentativeCost + vertexHeuristicCost[adjacentVertexId];
                openVertices.add(Pair.create(adjacentVertex, priorityCost));
            }
        }
        PlanItException.throwIf(currentVertex.getId() != destination.getId(), String.format("destination %s (id:%d) unreachable from origin %d (id:%d)", destination.getExternalId(), destination.getId(), origin.getExternalId(), origin.getId()));
        return new ShortestPathResult(vertexMeasuredCost, incomingEdgeSegment);
    }
}

