/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.shortestpath;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.planit.path.Path;
import org.planit.path.PathImpl;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGroupingToken;

public class ShortestPathResult {
    private static final Logger LOGGER = Logger.getLogger(ShortestPathResult.class.getCanonicalName());
    protected final double[] vertexMeasuredCost;
    protected final EdgeSegment[] incomingEdgeSegment;

    protected ShortestPathResult(double[] vertexMeasuredCost, EdgeSegment[] incomingEdgeSegment) {
        this.vertexMeasuredCost = vertexMeasuredCost;
        this.incomingEdgeSegment = incomingEdgeSegment;
    }

    public Path createPath(IdGroupingToken groupId, Vertex origin, Vertex destination) {
        LinkedList<EdgeSegment> pathEdgeSegments = new LinkedList<EdgeSegment>();
        int vertexId = (int)destination.getId();
        EdgeSegment previousEdgeSegmentOnPath = this.incomingEdgeSegment[vertexId];
        int originVertexId = (int)origin.getId();
        while (originVertexId != vertexId) {
            if (previousEdgeSegmentOnPath == null) {
                LOGGER.warning(String.format("unable to extract path from origin %s (id:%d) to destination %s (id:%d)", origin.getExternalId(), origin.getId(), destination.getExternalId(), destination.getId()));
                return null;
            }
            pathEdgeSegments.addFirst(previousEdgeSegmentOnPath);
            vertexId = (int)previousEdgeSegmentOnPath.getUpstreamVertex().getId();
            previousEdgeSegmentOnPath = this.incomingEdgeSegment[vertexId];
        }
        return new PathImpl(groupId, pathEdgeSegments);
    }

    public EdgeSegment getIncomingEdgeSegmentForVertex(Vertex vertex) {
        return this.incomingEdgeSegment[(int)vertex.getId()];
    }

    public double getCostToReach(Vertex vertex) {
        return this.vertexMeasuredCost[(int)vertex.getId()];
    }
}

