/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment;

import java.util.Calendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignment;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.mode.Mode;

public abstract class StaticTrafficAssignment
extends TrafficAssignment {
    private static final long serialVersionUID = -2600601431539929608L;
    private static final Logger LOGGER = Logger.getLogger(StaticTrafficAssignment.class.getCanonicalName());

    protected abstract void executeTimePeriod(TimePeriod var1, Set<Mode> var2) throws PlanItException;

    protected void executeTimePeriod(TimePeriod timePeriod) throws PlanItException {
        Calendar startTime;
        Calendar initialStartTime = startTime = Calendar.getInstance();
        this.executeTimePeriod(timePeriod, this.demands.getRegisteredModesForTimePeriod(timePeriod));
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("run time: %d milliseconds", startTime.getTimeInMillis() - initialStartTime.getTimeInMillis()));
    }

    protected StaticTrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    @Override
    public void executeEquilibration() throws PlanItException {
        SortedSet<TimePeriod> timePeriods = this.demands.timePeriods.asSortedSetByStartTime();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + "total time periods: " + timePeriods.size());
        for (TimePeriod timePeriod : timePeriods) {
            LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createTimePeriodPrefix(timePeriod.getExternalId(), timePeriod.getId()) + timePeriod.toString());
            this.executeTimePeriod(timePeriod);
        }
    }
}

