/*
 * Decompiled with CFR 0.152.
 */
package org.planit.assignment.traditionalstatic;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.planit.assignment.SimulationData;
import org.planit.assignment.traditionalstatic.ModeData;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odpath.ODPathMatrix;
import org.planit.output.configuration.ODOutputTypeConfiguration;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.utils.arrays.ArrayUtils;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.zoning.Zones;

public class TraditionalStaticAssignmentSimulationData
extends SimulationData {
    private IdGroupingToken groupId;
    private final Map<Mode, ModeData> modeSpecificData;
    private Map<Mode, double[]> modalNetworkSegmentCostsMap;
    private Map<Mode, Map<ODSkimSubOutputType, ODSkimMatrix>> modalSkimMatrixMap;
    private Map<Mode, ODPathMatrix> modalODPathMatrixMap;

    public TraditionalStaticAssignmentSimulationData(IdGroupingToken groupId) throws PlanItException {
        this.groupId = groupId;
        this.modeSpecificData = new TreeMap<Mode, ModeData>();
        this.modalNetworkSegmentCostsMap = new HashMap<Mode, double[]>();
        this.modalSkimMatrixMap = new HashMap<Mode, Map<ODSkimSubOutputType, ODSkimMatrix>>();
        this.modalODPathMatrixMap = new HashMap<Mode, ODPathMatrix>();
    }

    public Map<Mode, ModeData> getModeSpecificData() {
        return this.modeSpecificData;
    }

    public double collectTotalNetworkSegmentFlow(LinkSegment linkSegment) {
        return this.modeSpecificData.values().stream().collect(Collectors.summingDouble(modeData -> modeData.getCurrentSegmentFlows()[(int)linkSegment.getId()]));
    }

    public double[] collectTotalNetworkSegmentFlows() {
        Collection<ModeData> modeData = this.modeSpecificData.values();
        double[] networkSegmentFlows = null;
        for (ModeData modeDataEntry : modeData) {
            if (networkSegmentFlows == null) {
                networkSegmentFlows = Arrays.copyOf(modeDataEntry.getCurrentSegmentFlows(), modeDataEntry.getCurrentSegmentFlows().length);
                continue;
            }
            ArrayUtils.addTo(networkSegmentFlows, modeDataEntry.getCurrentSegmentFlows());
        }
        return networkSegmentFlows;
    }

    public void setModalLinkSegmentCosts(Mode mode, double[] modalLinkSegmentCosts) {
        this.modalNetworkSegmentCostsMap.put(mode, modalLinkSegmentCosts);
    }

    public double[] getModalLinkSegmentCosts(Mode mode) {
        return this.modalNetworkSegmentCostsMap.get(mode);
    }

    public void resetSkimMatrix(Mode mode, Zones<?> zones, ODOutputTypeConfiguration originDestinationOutputTypeConfiguration) {
        this.modalSkimMatrixMap.put(mode, new HashMap());
        for (SubOutputTypeEnum odSkimOutputType : originDestinationOutputTypeConfiguration.getActiveSubOutputTypes()) {
            ODSkimMatrix odSkimMatrix = new ODSkimMatrix(zones, (ODSkimSubOutputType)odSkimOutputType);
            this.modalSkimMatrixMap.get(mode).put((ODSkimSubOutputType)odSkimOutputType, odSkimMatrix);
        }
    }

    public void resetPathMatrix(Mode mode, Zones<?> zones) {
        this.modalODPathMatrixMap.put(mode, new ODPathMatrix(this.groupId, zones));
    }

    public ODSkimMatrix getODSkimMatrix(ODSkimSubOutputType odSkimOutputType, Mode mode) {
        Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap;
        if (this.modalSkimMatrixMap.containsKey(mode) && (skimMatrixMap = this.modalSkimMatrixMap.get(mode)).containsKey(odSkimOutputType)) {
            return skimMatrixMap.get(odSkimOutputType);
        }
        return null;
    }

    public ODPathMatrix getODPathMatrix(Mode mode) {
        return this.modalODPathMatrixMap.get(mode);
    }

    public Map<ODSkimSubOutputType, ODSkimMatrix> getSkimMatrixMap(Mode mode) {
        return this.modalSkimMatrixMap.get(mode);
    }
}

