/*
 * Decompiled with CFR 0.152.
 */
package org.planit.cost.physical;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.cost.physical.AbstractPhysicalCost;
import org.planit.interactor.LinkVolumeAccessee;
import org.planit.interactor.LinkVolumeAccessor;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.macroscopic.MacroscopicNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.arrays.ArrayUtils;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.Pair;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;

public class BPRLinkTravelTimeCost
extends AbstractPhysicalCost
implements LinkVolumeAccessor {
    private static final long serialVersionUID = -1529475107840907959L;
    private static final Logger LOGGER = Logger.getLogger(BPRLinkTravelTimeCost.class.getCanonicalName());
    protected MacroscopicPhysicalNetwork networkLayer;
    protected LinkVolumeAccessee linkVolumeAccessee = null;
    protected Pair<Double, Double> defaultParameters;
    protected BPRParameters defaultParametersPerMode;
    protected Map<MacroscopicLinkSegmentType, BPRParameters> defaultParametersPerLinkSegmentTypeAndMode;
    protected Map<MacroscopicLinkSegment, BPRParameters> parametersPerLinkSegmentAndMode = new HashMap<MacroscopicLinkSegment, BPRParameters>();
    protected BPRParameters[] bprParametersPerLinkSegment;
    protected double[][] freeFlowTravelTimePerLinkSegment;
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 4.0;

    protected double computeCostInHours(MacroscopicLinkSegment linkSegment, Mode mode, double flowPcuPerHour) {
        int id = (int)linkSegment.getId();
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()][id];
        double capacity = linkSegment.computeCapacityPcuH();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = alphaBetaParameters.first();
        double beta = alphaBetaParameters.second();
        return freeFlowTravelTime * (1.0 + alpha * Math.pow(flowPcuPerHour / capacity, beta));
    }

    public BPRLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.defaultParametersPerMode = new BPRParameters();
        this.defaultParametersPerLinkSegmentTypeAndMode = new HashMap<MacroscopicLinkSegmentType, BPRParameters>();
        this.defaultParameters = Pair.create(0.5, 4.0);
    }

    public void setParameters(MacroscopicLinkSegment linkSegment, Mode mode, double alpha, double beta) {
        if (this.parametersPerLinkSegmentAndMode.get(linkSegment) == null) {
            this.parametersPerLinkSegmentAndMode.put(linkSegment, new BPRParameters());
        }
        this.parametersPerLinkSegmentAndMode.get(linkSegment).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(Mode mode, double alpha, double beta) {
        this.defaultParametersPerMode.registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(MacroscopicLinkSegmentType macroscopicLinkSegmentType, Mode mode, double alpha, double beta) {
        if (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) == null) {
            this.defaultParametersPerLinkSegmentTypeAndMode.put(macroscopicLinkSegmentType, new BPRParameters());
        }
        this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(double alpha, double beta) {
        this.defaultParameters = Pair.create(alpha, beta);
    }

    @Override
    public double getSegmentCost(Mode mode, MacroscopicLinkSegment linkSegment) throws PlanItException {
        return this.computeCostInHours(linkSegment, mode, this.linkVolumeAccessee.getLinkSegmentFlow(linkSegment));
    }

    @Override
    public void populateWithCost(Mode mode, double[] costToFill) throws PlanItException {
        double[] linkSegmentFlows = this.linkVolumeAccessee.getLinkSegmentFlows();
        for (MacroscopicLinkSegment linkSegment : this.networkLayer.linkSegments) {
            int id = (int)linkSegment.getId();
            costToFill[id] = this.computeCostInHours(linkSegment, mode, linkSegmentFlows[id]);
        }
    }

    @Override
    public void initialiseBeforeSimulation(InfrastructureNetwork network) throws PlanItException {
        PlanItException.throwIf(!(network instanceof MacroscopicNetwork), "BPR cost is only compatible with macroscopic networks");
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf(macroscopicNetwork.infrastructureLayers.size() != 1, "BPR cost is currently only compatible with networks using a single infrastructure layer");
        InfrastructureLayer infrastructureLayer = macroscopicNetwork.infrastructureLayers.getFirst();
        PlanItException.throwIf(!(infrastructureLayer instanceof MacroscopicPhysicalNetwork), "BPR cost is only compatible with macroscopic physical network layers");
        this.networkLayer = (MacroscopicPhysicalNetwork)infrastructureLayer;
        if (network.modes.size() != this.networkLayer.getSupportedModes().size()) {
            LOGGER.warning("network wide modes do not match modes supported by only layer, this makes the assignment less efficient, consider removing unused modes");
        }
        this.freeFlowTravelTimePerLinkSegment = new double[network.modes.size()][(int)this.networkLayer.linkSegments.size()];
        ArrayUtils.loopAll(this.freeFlowTravelTimePerLinkSegment, (modeId, linkSegmentId) -> {
            this.freeFlowTravelTimePerLinkSegment[modeId.intValue()][linkSegmentId.intValue()] = ((MacroscopicLinkSegment)this.networkLayer.linkSegments.get(linkSegmentId.intValue())).computeFreeFlowTravelTime(network.modes.get(modeId.intValue()));
        });
        this.bprParametersPerLinkSegment = new BPRParameters[(int)this.networkLayer.linkSegments.size()];
        for (MacroscopicLinkSegment macroscopicLinkSegment : this.networkLayer.linkSegments) {
            int id = (int)macroscopicLinkSegment.getId();
            this.bprParametersPerLinkSegment[id] = new BPRParameters();
            MacroscopicLinkSegmentType macroscopicLinkSegmentType = macroscopicLinkSegment.getLinkSegmentType();
            for (Mode mode : network.modes) {
                Pair<Double, Double> alphaBetaPair = this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment) != null && this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) != null ? this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) : (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) != null && this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) != null ? this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) : (this.defaultParametersPerMode.getAlphaBetaParameters(mode) != null ? this.defaultParametersPerMode.getAlphaBetaParameters(mode) : this.defaultParameters));
                this.bprParametersPerLinkSegment[id].registerParameters(mode, alphaBetaPair);
            }
        }
    }

    @Override
    public void setLinkVolumeAccessee(LinkVolumeAccessee linkVolumeAccessee) {
        this.linkVolumeAccessee = linkVolumeAccessee;
    }

    public class BPRParameters {
        private final Map<Mode, Pair<Double, Double>> parametersMap = new HashMap<Mode, Pair<Double, Double>>();

        private void registerParameters(Mode mode, double alpha, double beta) {
            this.parametersMap.put(mode, Pair.create(alpha, beta));
        }

        private void registerParameters(Mode mode, Pair<Double, Double> pair) {
            this.parametersMap.put(mode, pair);
        }

        public Pair<Double, Double> getAlphaBetaParameters(Mode mode) {
            return this.parametersMap.get(mode);
        }
    }
}

