/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.logging.Logger;
import org.planit.graph.DirectedEdgeImpl;
import org.planit.graph.DirectedGraphBuilder;
import org.planit.graph.DirectedVertexImpl;
import org.planit.graph.EdgeSegmentImpl;
import org.planit.graph.EdgeSegmentsImpl;
import org.planit.graph.GraphBuilderImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.EdgeSegments;
import org.planit.utils.graph.Edges;
import org.planit.utils.graph.Vertex;
import org.planit.utils.graph.Vertices;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class DirectedGraphBuilderImpl
implements DirectedGraphBuilder<DirectedVertex, DirectedEdge, EdgeSegment> {
    private static final Logger LOGGER = Logger.getLogger(DirectedGraphBuilderImpl.class.getCanonicalName());
    private final GraphBuilderImpl graphBuilder;

    public DirectedGraphBuilderImpl(IdGroupingToken groupId) {
        this.graphBuilder = new GraphBuilderImpl(groupId);
    }

    @Override
    public DirectedVertex createVertex() {
        return new DirectedVertexImpl(this.graphBuilder.getIdGroupingToken());
    }

    @Override
    public DirectedEdge createEdge(Vertex vertexA, Vertex vertexB, double lengthKm) throws PlanItException {
        if (vertexA instanceof DirectedVertex && vertexB instanceof DirectedVertex) {
            return new DirectedEdgeImpl(this.graphBuilder.getIdGroupingToken(), (DirectedVertex)vertexA, (DirectedVertex)vertexB, lengthKm);
        }
        throw new PlanItException("unable to create directed edge since provides vertices are not directed");
    }

    @Override
    public EdgeSegment createEdgeSegment(DirectedEdge parentEdge, boolean directionAB) throws PlanItException {
        return new EdgeSegmentImpl(this.graphBuilder.getIdGroupingToken(), parentEdge, directionAB);
    }

    @Override
    public void setIdGroupingToken(IdGroupingToken groupToken) {
        this.graphBuilder.setIdGroupingToken(groupToken);
    }

    @Override
    public IdGroupingToken getIdGroupingToken() {
        return this.graphBuilder.getIdGroupingToken();
    }

    @Override
    public void recreateIds(Edges<? extends DirectedEdge> edges) {
        this.graphBuilder.recreateIds((Edges<? extends Edge>)edges);
    }

    @Override
    public void recreateIds(Vertices<? extends DirectedVertex> vertices) {
        this.graphBuilder.recreateIds((Vertices<? extends Vertex>)vertices);
    }

    @Override
    public void recreateIds(EdgeSegments<? extends EdgeSegment> edgeSegments) {
        if (edgeSegments instanceof EdgeSegmentsImpl) {
            IdGenerator.reset(this.getIdGroupingToken(), EdgeSegment.class);
            for (EdgeSegment edgeSegment : edgeSegments) {
                if (edgeSegment instanceof EdgeSegmentImpl) {
                    ((EdgeSegmentImpl)edgeSegment).setId(EdgeSegmentImpl.generateEdgeSegmentId(this.getIdGroupingToken()));
                    continue;
                }
                LOGGER.severe(String.format("attempting to reset id on edgse segment (%s) that is not compatible with the edge segment implementation generated by this builder, ignored", edgeSegment.getClass().getCanonicalName()));
            }
            ((EdgeSegmentsImpl)edgeSegments).updateIdMapping();
        } else {
            LOGGER.severe("expected the Edge segment implementation to be compatible with graph builder, this is not the case: unable to correctly remove subnetwork and update ids");
        }
    }

    @Override
    public DirectedEdge createUniqueCopyOf(DirectedEdge edgeToCopy) {
        if (edgeToCopy instanceof DirectedEdgeImpl) {
            return (DirectedEdgeImpl)this.graphBuilder.createUniqueCopyOf(edgeToCopy);
        }
        LOGGER.severe("passed in directed edge is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }

    @Override
    public EdgeSegment createUniqueCopyOf(EdgeSegment edgeSegmentToCopy, DirectedEdge newParentEdge) {
        if (edgeSegmentToCopy instanceof EdgeSegmentImpl) {
            EdgeSegmentImpl copy = (EdgeSegmentImpl)edgeSegmentToCopy.clone();
            copy.setId(EdgeSegmentImpl.generateEdgeSegmentId(this.getIdGroupingToken()));
            copy.setParentEdge(newParentEdge);
            return copy;
        }
        LOGGER.severe("passed in edge segment is not an instance created by this builder, incompatible for creating a copy");
        return null;
    }
}

