/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.planit.graph.VertexImpl;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.IdGroupingToken;

public class DirectedVertexImpl
extends VertexImpl
implements DirectedVertex {
    private static final long serialVersionUID = 2165199386965239623L;
    private static final Logger LOGGER = Logger.getLogger(DirectedVertexImpl.class.getCanonicalName());
    protected final Set<EdgeSegment> entryEdgeSegments = new TreeSet<EdgeSegment>();
    protected final Set<EdgeSegment> exitEdgeSegments = new TreeSet<EdgeSegment>();

    protected DirectedVertexImpl(IdGroupingToken groupId) {
        super(groupId);
    }

    protected DirectedVertexImpl(DirectedVertexImpl directedVertexImpl) {
        super(directedVertexImpl);
        this.entryEdgeSegments.addAll(directedVertexImpl.getEntryEdgeSegments());
        this.exitEdgeSegments.addAll(directedVertexImpl.getExitEdgeSegments());
    }

    @Override
    public Set<EdgeSegment> getEntryEdgeSegments() {
        return this.entryEdgeSegments;
    }

    @Override
    public Set<EdgeSegment> getExitEdgeSegments() {
        return this.exitEdgeSegments;
    }

    @Override
    public boolean addEdgeSegment(EdgeSegment edgeSegment) {
        if (edgeSegment.getUpstreamVertex().getId() == this.getId()) {
            return this.exitEdgeSegments.add(edgeSegment);
        }
        if (edgeSegment.getDownstreamVertex().getId() == this.getId()) {
            return this.entryEdgeSegments.add(edgeSegment);
        }
        LOGGER.warning(String.format("edge segment %s (id:%d) does not have this vertex %s (%d) on either end", edgeSegment.getExternalId(), edgeSegment.getId()));
        return false;
    }

    @Override
    public boolean removeEdgeSegment(EdgeSegment edgeSegment) {
        boolean removed = false;
        removed = this.exitEdgeSegments.remove(edgeSegment);
        if (!removed) {
            removed = this.entryEdgeSegments.remove(edgeSegment);
        }
        return removed;
    }

    @Override
    public boolean hasExitEdgeSegments() {
        return this.exitEdgeSegments.isEmpty();
    }

    @Override
    public boolean hasEntryEdgeSegments() {
        return this.entryEdgeSegments.isEmpty();
    }

    @Override
    public int getNumberOfEntryEdgeSegments() {
        return this.entryEdgeSegments.size();
    }

    @Override
    public int getNumberOfExitEdgeSegments() {
        return this.exitEdgeSegments.size();
    }

    @Override
    public DirectedVertexImpl clone() {
        return new DirectedVertexImpl(this);
    }
}

