/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.logging.Logger;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class EdgeSegmentImpl
implements EdgeSegment {
    private static final long serialVersionUID = -6521489123632246969L;
    private static final Logger LOGGER = Logger.getLogger(EdgeSegmentImpl.class.getCanonicalName());
    private long id;
    private DirectedVertex upstreamVertex;
    private DirectedVertex downstreamVertex;
    private DirectedEdge parentEdge;
    private String externalId;
    protected String xmlId;

    protected static long generateEdgeSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, EdgeSegment.class);
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, DirectedEdge parentEdge, boolean directionAB) throws PlanItException {
        this.setId(EdgeSegmentImpl.generateEdgeSegmentId(groupId));
        this.setParentEdge(parentEdge);
        if (!(parentEdge.getVertexA() instanceof DirectedVertex) || !(parentEdge.getVertexB() instanceof DirectedVertex)) {
            throw new PlanItException(String.format("parent edges (id:%d) vertices do not support directed edge segments, they must be of type DirectedVertex", parentEdge.getId()));
        }
        this.setUpstreamVertex((DirectedVertex)(directionAB ? parentEdge.getVertexA() : parentEdge.getVertexB()));
        this.setDownstreamVertex((DirectedVertex)(directionAB ? parentEdge.getVertexB() : parentEdge.getVertexA()));
    }

    protected EdgeSegmentImpl(EdgeSegmentImpl edgeSegmentImpl) {
        this.setId(edgeSegmentImpl.getId());
        this.setXmlId(edgeSegmentImpl.getXmlId());
        this.setExternalId(edgeSegmentImpl.getExternalId());
        this.setParentEdge(edgeSegmentImpl.getParentEdge());
        this.setUpstreamVertex(edgeSegmentImpl.getUpstreamVertex());
        this.setDownstreamVertex(edgeSegmentImpl.getDownstreamVertex());
    }

    public int hashCode() {
        return this.idHashCode();
    }

    public boolean equals(Object obj) {
        return this.idEquals(obj);
    }

    @Override
    public boolean remove(DirectedVertex vertex) {
        if (vertex != null) {
            if (this.getUpstreamVertex() != null && this.getUpstreamVertex().getId() == vertex.getId()) {
                this.upstreamVertex = null;
                return true;
            }
            if (this.getDownstreamVertex() != null && this.getDownstreamVertex().getId() == vertex.getId()) {
                this.downstreamVertex = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDownstreamVertex(DirectedVertex downstreamVertex) {
        this.downstreamVertex = downstreamVertex;
    }

    @Override
    public void setUpstreamVertex(DirectedVertex upstreamVertex) {
        this.upstreamVertex = upstreamVertex;
    }

    @Override
    public DirectedVertex getUpstreamVertex() {
        return this.upstreamVertex;
    }

    @Override
    public DirectedVertex getDownstreamVertex() {
        return this.downstreamVertex;
    }

    @Override
    public boolean isDirectionAb() {
        return this.getParentEdge().hasEdgeSegmentAb() && this.getParentEdge().getEdgeSegmentAb().getId() == this.getId();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public DirectedEdge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public void setParentEdge(DirectedEdge parentEdge) {
        this.parentEdge = parentEdge;
    }

    @Override
    public void removeParentEdge() {
        this.parentEdge = null;
    }

    @Override
    public EdgeSegment clone() {
        return new EdgeSegmentImpl(this);
    }

    @Override
    public boolean validate() {
        if (this.parentEdge == null) {
            LOGGER.warning(String.format("parent edge missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getUpstreamVertex() == null) {
            LOGGER.warning(String.format("upstream vertex missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getDownstreamVertex() == null) {
            LOGGER.warning(String.format("downstream vertex missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getParentEdge().getVertexA() == this.getUpstreamVertex()) {
            if (this.getParentEdge().getEdgeSegmentAb() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", this.getId(), this.getExternalId()));
                return false;
            }
            if (!this.getParentEdge().getEdgeSegmentAb().equals(this)) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", this.getId(), this.getExternalId()));
                return false;
            }
        }
        if (this.getParentEdge().getVertexB() == this.getUpstreamVertex()) {
            if (this.getParentEdge().getEdgeSegmentBa() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", this.getId(), this.getExternalId()));
                return false;
            }
            if (!this.getParentEdge().getEdgeSegmentBa().equals(this)) {
                LOGGER.warning(String.format("edge segment B->A on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", this.getId(), this.getExternalId()));
                return false;
            }
        }
        if (this.getParentEdge().getVertexA().equals(this.getUpstreamVertex())) {
            if (!this.getParentEdge().getVertexB().equals(this.getDownstreamVertex())) {
                LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", this.getId(), this.getExternalId()));
                return false;
            }
        } else if (!this.getParentEdge().getVertexB().equals(this.getUpstreamVertex()) || !this.getParentEdge().getVertexA().equals(this.getDownstreamVertex())) {
            LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }
}

