/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.graph.DirectedGraphBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.DirectedEdge;
import org.planit.utils.graph.DirectedVertex;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.EdgeSegments;

public class EdgeSegmentsImpl<ES extends EdgeSegment>
implements EdgeSegments<ES> {
    private static final Logger LOGGER = Logger.getLogger(EdgeSegmentsImpl.class.getCanonicalName());
    protected DirectedGraphBuilder<? extends DirectedVertex, ? extends DirectedEdge, ES> directedGraphBuilder;
    private Map<Long, ES> edgeSegmentMap;

    protected void updateIdMapping() {
        HashMap updatedMap = new HashMap(this.edgeSegmentMap.size());
        this.edgeSegmentMap.forEach((? super K oldId, ? super V edgeSegment) -> updatedMap.put(edgeSegment.getId(), edgeSegment));
        this.edgeSegmentMap = updatedMap;
    }

    public void register(ES edgeSegment) {
        this.edgeSegmentMap.put(edgeSegment.getId(), edgeSegment);
    }

    public EdgeSegmentsImpl(DirectedGraphBuilder<? extends DirectedVertex, ? extends DirectedEdge, ES> graphBuilder) {
        this.directedGraphBuilder = graphBuilder;
        this.edgeSegmentMap = new TreeMap<Long, ES>();
    }

    @Override
    public void remove(ES edgeSegment) {
        this.edgeSegmentMap.remove(edgeSegment.getId());
    }

    @Override
    public void remove(long edgeSegmentId) {
        this.edgeSegmentMap.remove(edgeSegmentId);
    }

    @Override
    public Iterator<ES> iterator() {
        return this.edgeSegmentMap.values().iterator();
    }

    @Override
    public ES create(DirectedEdge parentEdge, boolean directionAB) throws PlanItException {
        ES edgeSegment = this.directedGraphBuilder.createEdgeSegment(parentEdge, directionAB);
        return edgeSegment;
    }

    @Override
    public void register(DirectedEdge parentEdge, ES edgeSegment, boolean directionAB) throws PlanItException {
        parentEdge.registerEdgeSegment((EdgeSegment)edgeSegment, directionAB);
        this.register(edgeSegment);
    }

    @Override
    public ES registerNew(DirectedEdge parentEdge, boolean directionAb, boolean registerOnNodeAndLink) throws PlanItException {
        ES edgeSegment = this.create(parentEdge, directionAb);
        this.register(parentEdge, edgeSegment, directionAb);
        if (registerOnNodeAndLink) {
            parentEdge.registerEdgeSegment((EdgeSegment)edgeSegment, directionAb);
            if (parentEdge.getVertexA() instanceof DirectedVertex) {
                ((DirectedVertex)parentEdge.getVertexA()).addEdgeSegment((EdgeSegment)edgeSegment);
                ((DirectedVertex)parentEdge.getVertexB()).addEdgeSegment((EdgeSegment)edgeSegment);
            }
        }
        return edgeSegment;
    }

    @Override
    public ES get(long id) {
        return (ES)((EdgeSegment)this.edgeSegmentMap.get(id));
    }

    @Override
    public ES getByXmlId(String xmlId) {
        for (EdgeSegment edgeSegment : this) {
            if (!xmlId.equals(edgeSegment.getXmlId())) continue;
            return (ES)edgeSegment;
        }
        return null;
    }

    @Override
    public long size() {
        return this.edgeSegmentMap.size();
    }

    @Override
    public ES registerUniqueCopyOf(ES edgeSegmentToCopy, DirectedEdge newParentEdge) {
        ES copy = this.directedGraphBuilder.createUniqueCopyOf(edgeSegmentToCopy, newParentEdge);
        this.register(copy);
        return copy;
    }
}

