/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.locationtech.jts.geom.Point;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class VertexImpl
implements Vertex {
    private static final Logger LOGGER = Logger.getLogger(VertexImpl.class.getCanonicalName());
    private static final long serialVersionUID = -2877566769607366608L;
    protected long id;
    protected String externalId;
    private String xmlId;
    protected Map<String, Object> inputProperties = null;
    protected Point position;
    protected final Map<Long, Edge> edges = new HashMap<Long, Edge>();

    protected static long generateVertexId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Vertex.class);
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected VertexImpl(IdGroupingToken groupId) {
        this.id = VertexImpl.generateVertexId(groupId);
    }

    protected VertexImpl(VertexImpl vertexImpl) {
        this.setId(vertexImpl.getId());
        this.setXmlId(vertexImpl.getXmlId());
        this.setExternalId(vertexImpl.getExternalId());
        this.setPosition((Point)vertexImpl.getPosition().clone());
        this.edges.putAll(vertexImpl.edges);
        this.inputProperties = null;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point position) {
        this.position = position;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public boolean addEdge(Edge edge) {
        return this.edges.put(edge.getId(), edge) != null;
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.removeEdge(edge.getId());
    }

    @Override
    public boolean removeEdge(long edgeId) {
        return this.edges.remove(edgeId) != null;
    }

    public Collection<Edge> getEdges() {
        return this.edges.values();
    }

    @Override
    public int getNumberOfEdges() {
        return this.edges.size();
    }

    @Override
    public Set<Edge> getEdges(Vertex otherVertex) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Edge edge : this.getEdges()) {
            if (edge.getVertexA().getId() == this.getId() && edge.getVertexB().getId() == otherVertex.getId()) {
                edges.add(edge);
                continue;
            }
            if (edge.getVertexB().getId() != this.getId() || edge.getVertexA().getId() != otherVertex.getId()) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public VertexImpl clone() {
        return new VertexImpl(this);
    }

    @Override
    public boolean validate() {
        for (Edge edge : this.getEdges()) {
            if (edge.hasVertex(this)) continue;
            LOGGER.warning(String.format("edge (id:%d) does not contain vertex (id:%d externalId:%s) even though the vertex is connected to it", edge.getId(), this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }
}

