/*
 * Decompiled with CFR 0.152.
 */
package org.planit.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.djutils.event.EventListenerInterface;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.time.TimePeriod;
import org.planit.userclass.TravelerType;
import org.planit.userclass.UserClass;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.zoning.Connectoid;
import org.planit.utils.zoning.Zone;

public abstract class InputBuilderListener
implements EventListenerInterface {
    private static final Logger LOGGER = Logger.getLogger(InputBuilderListener.class.getCanonicalName());
    private static final long serialVersionUID = 4223028100274802893L;
    protected Map<String, Node> sourceIdNodeMap = new HashMap<String, Node>();
    protected Map<String, MacroscopicLinkSegment> sourceIdLinkSegmentMap;
    protected Map<String, MacroscopicLinkSegmentType> sourceIdLinkSegmentTypeMap = new HashMap<String, MacroscopicLinkSegmentType>();
    protected Map<String, Mode> sourceIdModeMap = new HashMap<String, Mode>();
    protected Map<String, TravelerType> sourceIdTravelerTypeMap = new HashMap<String, TravelerType>();
    protected Map<String, UserClass> sourceIdUserClassMap = new HashMap<String, UserClass>();
    protected Map<String, TimePeriod> sourceIdTimePeriodMap = new HashMap<String, TimePeriod>();
    protected Map<String, Zone> sourceIdZoneMap = new HashMap<String, Zone>();
    protected Map<String, Connectoid> sourceIdConnectoidMap;
    public static boolean DEFAULT_ERROR_ON_DUPLICATE_SOURCE_ID = true;

    private <T> boolean addObjectToSourceIdMap(String sourceId, T obj, Map<String, T> map) {
        boolean containsDuplicates = map.containsKey(sourceId);
        map.put(sourceId, obj);
        return containsDuplicates;
    }

    protected boolean addNodeToSourceIdMap(String sourceId, Node node) {
        return this.addObjectToSourceIdMap(sourceId, node, this.sourceIdNodeMap);
    }

    protected boolean addModeToSourceIdMap(String sourceId, Mode mode) {
        return this.addObjectToSourceIdMap(sourceId, mode, this.sourceIdModeMap);
    }

    protected boolean addTravelerTypeToSourceIdMap(String sourceId, TravelerType travelerType) {
        return this.addObjectToSourceIdMap(sourceId, travelerType, this.sourceIdTravelerTypeMap);
    }

    protected boolean addUserClassToSourceIdMap(String sourceId, UserClass userClass) {
        return this.addObjectToSourceIdMap(sourceId, userClass, this.sourceIdUserClassMap);
    }

    protected boolean addTimePeriodToSourceIdMap(String sourceId, TimePeriod timePeriod) {
        return this.addObjectToSourceIdMap(sourceId, timePeriod, this.sourceIdTimePeriodMap);
    }

    protected boolean addZoneToSourceIdMap(String sourceId, Zone zone) {
        return this.addObjectToSourceIdMap(sourceId, zone, this.sourceIdZoneMap);
    }

    protected boolean addConnectoidToSourceIdMap(String sourceId, Connectoid connectoid) {
        return this.addObjectToSourceIdMap(sourceId, connectoid, this.sourceIdConnectoidMap);
    }

    protected boolean addLinkSegmentToSourceIdMap(String sourceId, MacroscopicLinkSegment linkSegment) {
        return this.addObjectToSourceIdMap(sourceId, linkSegment, this.sourceIdLinkSegmentMap);
    }

    public InputBuilderListener() {
        this.sourceIdLinkSegmentMap = new HashMap<String, MacroscopicLinkSegment>();
        this.sourceIdConnectoidMap = new HashMap<String, Connectoid>();
    }

    public Node getNodeByXmlId(String sourceId) {
        return this.sourceIdNodeMap.get(sourceId);
    }

    public MacroscopicLinkSegmentType getLinkSegmentTypeBySourceId(String sourceId) {
        return this.sourceIdLinkSegmentTypeMap.get(sourceId);
    }

    public Mode getModeBySourceId(String sourceId) {
        return this.sourceIdModeMap.get(sourceId);
    }

    public Map<String, Mode> getAllModesBySourceId() {
        return this.sourceIdModeMap;
    }

    public TravelerType getTravelerTypeBySourceId(String sourceId) {
        return this.sourceIdTravelerTypeMap.get(sourceId);
    }

    protected boolean addLinkSegmentTypeToSourceIdMap(String sourceId, MacroscopicLinkSegmentType macroscopicLinkSegmentType) {
        return this.addObjectToSourceIdMap(sourceId, macroscopicLinkSegmentType, this.sourceIdLinkSegmentTypeMap);
    }

    public UserClass getUserClassBySourceId(String sourceId) {
        return this.sourceIdUserClassMap.get(sourceId);
    }

    public TimePeriod getTimePeriodBySourceId(String sourceId) {
        return this.sourceIdTimePeriodMap.get(sourceId);
    }

    public boolean isTimePeriodSourceIdRegistered(String sourceId) {
        return this.sourceIdTimePeriodMap.keySet().contains(sourceId);
    }

    public int getNumberOfRegisteredTimePeriods() {
        return this.sourceIdTimePeriodMap.keySet().size();
    }

    public List<String> getTimePeriodSourceIds() {
        return new ArrayList<String>(this.sourceIdTimePeriodMap.keySet());
    }

    public Zone getZoneBySourceId(String sourceId) {
        return this.sourceIdZoneMap.get(sourceId);
    }

    public Zone getConnectoidBySourceId(String sourceId) {
        return this.sourceIdZoneMap.get(sourceId);
    }

    public MacroscopicLinkSegment getLinkSegmentByXmlId(String sourceId) {
        return this.sourceIdLinkSegmentMap.get(sourceId);
    }

    public MacroscopicLinkSegment getLinkSegmentByExternalId(InfrastructureNetwork network, String externalId) {
        for (InfrastructureLayer layer : network.infrastructureLayers) {
            MacroscopicLinkSegment linkSegment;
            if (!(layer instanceof MacroscopicPhysicalNetwork) || (linkSegment = (MacroscopicLinkSegment)((MacroscopicPhysicalNetwork)layer).linkSegments.getByExternalId(externalId)) == null) continue;
            return linkSegment;
        }
        return null;
    }
}

