/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.output.formatter;

import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.csv.CSVPrinter;
import org.planit.io.xml.converter.EnumConverter;
import org.planit.io.xml.util.ApplicationProperties;
import org.planit.io.xml.util.JAXBUtils;
import org.planit.io.xml.util.PlanitSchema;
import org.planit.output.adapter.OutputAdapter;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.OutputTypeEnum;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.formatter.CsvFileOutputFormatter;
import org.planit.output.formatter.CsvTextFileOutputFormatter;
import org.planit.output.formatter.XmlTextFileOutputFormatter;
import org.planit.output.property.BaseOutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.mode.Mode;
import org.planit.xml.generated.XMLElementColumn;
import org.planit.xml.generated.XMLElementColumns;
import org.planit.xml.generated.XMLElementCsvdata;
import org.planit.xml.generated.XMLElementIteration;
import org.planit.xml.generated.XMLElementMetadata;
import org.planit.xml.generated.XMLElementOutputConfiguration;
import org.planit.xml.generated.XMLElementOutputTimePeriod;
import org.planit.xml.generated.XMLElementSimulation;

public class PlanItOutputFormatter
extends CsvFileOutputFormatter
implements CsvTextFileOutputFormatter,
XmlTextFileOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(PlanItOutputFormatter.class.getCanonicalName());
    private static final String DEFAULT_XML_NAME_EXTENSION = ".xml";
    private static final String DEFAULT_XML_NAME_PREFIX = "XMLOutput";
    private static final String DEFAULT_CSV_NAME_EXTENSION = ".csv";
    private static final String DEFAULT_CSV_NAME_PREFIX = "CSVOutput";
    private String xmlDirectory = null;
    private String csvDirectory = null;
    private String xmlNameExtension = ".xml";
    private String xmlNameRoot = "XMLOutput";
    private String csvNameExtension = ".csv";
    private String csvNameRoot = "CSVOutput";
    private Map<OutputType, String> xmlFileNameMap = new HashMap<OutputType, String>();
    private boolean resetXmlDirectory = false;
    private boolean resetCsvDirectory = false;
    private Map<OutputTypeEnum, XMLElementMetadata> metadata = new HashMap<OutputTypeEnum, XMLElementMetadata>();

    private String createLoggingPrefix() {
        return LoggingUtils.createOutputFormatterPrefix(this.id);
    }

    private String createLoggingPrefix(long runId) {
        return LoggingUtils.createRunIdPrefix(runId) + this.createLoggingPrefix();
    }

    private String generateRelativeOutputFileName(OutputType outputType, OutputAdapter outputAdapter, TimePeriod timePeriod, int iteration) throws PlanItException {
        Path pathAbsolute = Paths.get(this.csvDirectory, new String[0]);
        Path pathBase = Paths.get(this.xmlDirectory, new String[0]);
        Path pathRelative = pathBase.relativize(pathAbsolute);
        String relativeCsvOutputDirectory = pathRelative.toString();
        relativeCsvOutputDirectory = relativeCsvOutputDirectory.equals("") ? "." : relativeCsvOutputDirectory;
        return this.generateOutputFileName(relativeCsvOutputDirectory, this.csvNameRoot, this.csvNameExtension, timePeriod, outputType, outputAdapter.getRunId(), iteration);
    }

    private void updateMetadataSimulationOutputForCurrentIteration(int iterationIndex, String csvFileName, OutputTypeEnum currentOutputType) throws PlanItException {
        XMLElementIteration iteration = new XMLElementIteration();
        iteration.setNr(BigInteger.valueOf(iterationIndex));
        XMLElementCsvdata csvdata = new XMLElementCsvdata();
        csvdata.setValue(csvFileName);
        iteration.getCsvdata().add(csvdata);
        if (currentOutputType instanceof OutputType) {
            csvdata.setType(((OutputType)currentOutputType).value());
            this.metadata.get((OutputType)currentOutputType).getSimulation().getIteration().add(iteration);
        } else if (currentOutputType instanceof SubOutputTypeEnum) {
            csvdata.setType(((SubOutputTypeEnum)currentOutputType).value());
            this.metadata.get((SubOutputTypeEnum)currentOutputType).getSimulation().getIteration().add(iteration);
        } else {
            throw new PlanItException("invalid output type provided when updating metadata simulation output for current iteration");
        }
    }

    private XMLGregorianCalendar getTimestamp() throws DatatypeConfigurationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        return datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    private XMLElementColumns getGeneratedColumnsFromProperties(SortedSet<BaseOutputProperty> outputProperties) throws PlanItException {
        XMLElementColumns generatedColumns = new XMLElementColumns();
        for (BaseOutputProperty outputProperty : outputProperties) {
            XMLElementColumn generatedColumn = new XMLElementColumn();
            generatedColumn.setName(outputProperty.getName());
            generatedColumn.setUnits(EnumConverter.convertFromPlanItToXmlGeneratedUnits(outputProperty.getUnits()));
            generatedColumn.setType(EnumConverter.convertFromPlanItToXmlGeneratedType(outputProperty.getType()));
            generatedColumns.getColumn().add(generatedColumn);
        }
        return generatedColumns;
    }

    private XMLElementOutputConfiguration getXmlOutputConfiguration(OutputAdapter outputAdapter, TimePeriod timePeriod) {
        XMLElementOutputConfiguration outputconfiguration = new XMLElementOutputConfiguration();
        outputconfiguration.setAssignment(outputAdapter.getAssignmentClassName());
        outputconfiguration.setPhysicalcost(outputAdapter.getPhysicalCostClassName());
        outputconfiguration.setVirtualcost(outputAdapter.getVirtualCostClassName());
        outputconfiguration.setSmoothing(outputAdapter.getSmoothingClassName());
        outputconfiguration.setGapfunction(outputAdapter.getGapFunctionClassName());
        outputconfiguration.setStopcriterion(outputAdapter.getStopCriterionClassName());
        XMLElementOutputTimePeriod xmlTimePeriod = new XMLElementOutputTimePeriod();
        xmlTimePeriod.setId(timePeriod.getXmlId());
        xmlTimePeriod.setName(timePeriod.getDescription());
        outputconfiguration.setTimeperiod(xmlTimePeriod);
        return outputconfiguration;
    }

    private void createOrOpenOutputDirectory(String outputDirectory, boolean resetDirectory) throws PlanItException {
        try {
            File directory = new File(outputDirectory);
            if (!directory.isDirectory()) {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            }
            if (resetDirectory) {
                this.purgeDirectory(outputDirectory);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when creating output directory in PLANitIO OutputFormatter", e);
        }
    }

    private void initializeMetadataObject(OutputTypeEnum currentOutputType, OutputTypeConfiguration outputTypeConfiguration, OutputAdapter outputAdapter, TimePeriod timePeriod) throws PlanItException {
        try {
            this.metadata.get(currentOutputType).setTimestamp(this.getTimestamp());
            this.metadata.get(currentOutputType).setVersion(ApplicationProperties.getVersion());
            this.metadata.get(currentOutputType).setDescription(ApplicationProperties.getDescription());
            XMLElementOutputConfiguration outputconfiguration = this.getXmlOutputConfiguration(outputAdapter, timePeriod);
            this.metadata.get(currentOutputType).setOutputconfiguration(outputconfiguration);
            SortedSet<BaseOutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            this.metadata.get(currentOutputType).setColumns(this.getGeneratedColumnsFromProperties(outputProperties));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when initialising meta data object in PLANitIO OutputFormatter", e);
        }
    }

    private void purgeDirectory(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.purgeDirectory(file);
            }
            file.delete();
        }
    }

    private void purgeDirectory(String directoryName) {
        File directory = new File(directoryName);
        this.purgeDirectory(directory);
    }

    private String createCsvFileNameAndFileForTimePeriodCurrentIteration(OutputTypeConfiguration outputTypeConfiguration, OutputAdapter outputAdapter, TimePeriod timePeriod, int iterationIndex, Function<CSVPrinter, PlanItException> createCsvFileForCurrentIteration) throws PlanItException {
        String csvFileName = this.generateOutputFileName(this.csvDirectory, this.csvNameRoot, this.csvNameExtension, timePeriod, outputTypeConfiguration.getOutputType(), outputAdapter.getRunId(), iterationIndex);
        try {
            CSVPrinter csvIterationPrinter = this.openCsvFileAndWriteHeaders(outputTypeConfiguration, csvFileName);
            PlanItException ple = createCsvFileForCurrentIteration.apply(csvIterationPrinter);
            if (ple != null) {
                throw ple;
            }
            csvIterationPrinter.close();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when createing CSV file name and file in PLANitIO OutputFormatter", e);
        }
        return csvFileName;
    }

    private void writeResultsForCurrentTimePeriod(OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, TimePeriod timePeriod, int iterationIndex, Function<CSVPrinter, PlanItException> createCsvFileForCurrentIteration) throws PlanItException {
        try {
            boolean isNewTimePeriod;
            OutputType outputType = outputTypeConfiguration.getOutputType();
            boolean bl = isNewTimePeriod = !this.metadata.containsKey(currentOutputType) || this.metadata.get(currentOutputType).getOutputconfiguration().getTimeperiod().getId() != timePeriod.getXmlId();
            if (isNewTimePeriod) {
                if (this.metadata.containsKey(currentOutputType)) {
                    JAXBUtils.generateXmlFileFromObject(this.metadata.get(currentOutputType), XMLElementMetadata.class, Paths.get(this.xmlFileNameMap.get(outputType), new String[0]), PlanitSchema.createPlanitSchemaUri("metadata.xsd"));
                }
                this.metadata.put(currentOutputType, new XMLElementMetadata());
                XMLElementSimulation simulation = new XMLElementSimulation();
                this.metadata.get(currentOutputType).setSimulation(simulation);
                this.initializeMetadataObject(currentOutputType, outputTypeConfiguration, outputAdapter, timePeriod);
            }
            String csvFileName = this.createCsvFileNameAndFileForTimePeriodCurrentIteration(outputTypeConfiguration, outputAdapter, timePeriod, iterationIndex, createCsvFileForCurrentIteration);
            String relativeCsvFileName = this.generateRelativeOutputFileName(outputTypeConfiguration.getOutputType(), outputAdapter, timePeriod, iterationIndex);
            this.updateMetadataSimulationOutputForCurrentIteration(iterationIndex, relativeCsvFileName, currentOutputType);
            this.addCsvFileNamePerOutputType(currentOutputType, csvFileName);
            if (isNewTimePeriod) {
                this.xmlFileNameMap.put(outputType, this.generateOutputFileName(this.xmlDirectory, this.xmlNameRoot, this.xmlNameExtension, timePeriod, outputType, outputAdapter.getRunId()));
            }
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when writing results for current time period in PLANitIO OutputFormatter", e);
        }
    }

    private void logOutputInformation(OutputAdapter outputAdapter) {
        if (this.isXmlDirectorySet()) {
            LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "XML meta-data directory set: " + this.xmlDirectory);
        } else {
            LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "XML meta-data output directory unknown");
        }
        if (this.isCsvDirectorySet()) {
            LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "CSV result directory set: " + this.csvDirectory);
        } else {
            LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "CSV result directory unknown");
        }
    }

    @Override
    protected void writeSimulationResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "XML Output for OutputType SIMULATION has not been implemented yet.");
    }

    @Override
    protected void writeGeneralResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.info(this.createLoggingPrefix(outputAdapter.getRunId()) + "XML Output for OutputType GENERAL has not been implemented yet.");
    }

    @Override
    protected void writeOdResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        this.writeResultsForCurrentTimePeriod(outputTypeConfiguration, currentOutputType, outputAdapter, timePeriod, iterationIndex, csvPrinter -> this.writeOdResultsForCurrentTimePeriodToCsvPrinter(outputConfiguration, outputTypeConfiguration, currentOutputType, outputAdapter, modes, timePeriod, (CSVPrinter)csvPrinter));
    }

    @Override
    protected void writePathResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        this.writeResultsForCurrentTimePeriod(outputTypeConfiguration, currentOutputType, outputAdapter, timePeriod, iterationIndex, csvPrinter -> this.writePathResultsForCurrentTimePeriodToCsvPrinter(outputConfiguration, outputTypeConfiguration, currentOutputType, outputAdapter, modes, timePeriod, (CSVPrinter)csvPrinter));
    }

    @Override
    protected void writeLinkResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        this.writeResultsForCurrentTimePeriod(outputTypeConfiguration, currentOutputType, outputAdapter, timePeriod, iterationIndex, csvPrinter -> this.writeLinkResultsForCurrentTimePeriodToCsvPrinter(outputConfiguration, outputTypeConfiguration, currentOutputType, outputAdapter, modes, timePeriod, (CSVPrinter)csvPrinter));
    }

    public PlanItOutputFormatter(IdGroupingToken groupId) throws PlanItException {
        super(groupId);
    }

    @Override
    public void initialiseBeforeSimulation(OutputConfiguration outputConfiguration, long runId) throws PlanItException {
        PlanItException.throwIf(this.xmlDirectory == null, "No common output directory or XML output directory has been defined");
        PlanItException.throwIf(this.csvDirectory == null, "No common output directory or CSV output directory has been defined");
        this.createOrOpenOutputDirectory(this.xmlDirectory, this.resetXmlDirectory);
        this.createOrOpenOutputDirectory(this.csvDirectory, this.resetCsvDirectory);
    }

    @Override
    public void finaliseAfterSimulation(OutputConfiguration outputConfiguration, OutputAdapter outputAdapter) throws PlanItException {
        try {
            String metaDataSchemaUri = PlanitSchema.createPlanitSchemaUri("metadata.xsd");
            for (OutputType outputType : outputConfiguration.getActivatedOutputTypes()) {
                OutputTypeConfiguration outputTypeConfiguration = outputConfiguration.getOutputTypeConfiguration(outputType);
                if (!this.xmlFileNameMap.containsKey(outputType)) continue;
                Path xmlFilePath = Paths.get(this.xmlFileNameMap.get(outputType), new String[0]);
                if (this.metadata.containsKey(outputType)) {
                    JAXBUtils.generateXmlFileFromObject(this.metadata.get(outputType), XMLElementMetadata.class, xmlFilePath, metaDataSchemaUri);
                    continue;
                }
                if (!outputTypeConfiguration.hasActiveSubOutputTypes()) continue;
                Set<SubOutputTypeEnum> activeSubOutputTypes = outputTypeConfiguration.getActiveSubOutputTypes();
                for (SubOutputTypeEnum subOutputTypeEnum : activeSubOutputTypes) {
                    JAXBUtils.generateXmlFileFromObject(this.metadata.get(subOutputTypeEnum), XMLElementMetadata.class, xmlFilePath, metaDataSchemaUri);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when finalising after simulation in PLANitIO OutputFormatter", e);
        }
        this.logOutputInformation(outputAdapter);
    }

    public void resetXmlDirectory() throws PlanItException {
        this.resetXmlDirectory = true;
    }

    public void resetCsvDirectory() throws PlanItException {
        this.resetCsvDirectory = true;
    }

    @Override
    public void setXmlDirectory(String xmlDirectory) {
        this.xmlDirectory = xmlDirectory;
    }

    public boolean isXmlDirectorySet() {
        return this.xmlDirectory != null;
    }

    public boolean isCsvDirectorySet() {
        return this.csvDirectory != null;
    }

    @Override
    public void setCsvDirectory(String csvDirectory) {
        this.csvDirectory = csvDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.csvDirectory = outputDirectory;
        this.xmlDirectory = outputDirectory;
    }

    @Override
    public void setXmlNameExtension(String xmlNameExtension) {
        this.xmlNameExtension = xmlNameExtension;
    }

    @Override
    public void setXmlNameRoot(String xmlNameRoot) {
        this.xmlNameRoot = xmlNameRoot;
    }

    @Override
    public void setCsvNameRoot(String csvNameRoot) {
        this.csvNameRoot = csvNameRoot;
    }

    @Override
    public void setCsvNameExtension(String csvNameExtension) {
        this.csvNameExtension = csvNameExtension;
    }

    @Override
    public List<String> getCsvFileName(OutputType outputType) {
        return (List)this.csvFileNameMap.get(outputType);
    }

    @Override
    public boolean canHandleMultipleIterations() {
        return true;
    }

    @Override
    public String getXmlFileName(OutputType outputType) {
        return this.xmlFileNameMap.get(outputType);
    }

    @Override
    public void setXmlFileNamePerOutputType(OutputType outputType, String xmlFileName) {
        this.xmlFileNameMap.put(outputType, xmlFileName);
    }
}

