/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.network;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.opengis.gml.LineStringType;
import net.opengis.gml.PointType;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.planit.geo.PlanitJtsUtils;
import org.planit.io.network.converter.PlanitNetworkReaderSettings;
import org.planit.network.macroscopic.physical.MacroscopicModePropertiesFactory;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.TrackModeType;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.xml.generated.Accessmode;
import org.planit.xml.generated.Direction;
import org.planit.xml.generated.LengthUnit;
import org.planit.xml.generated.XMLElementInfrastructureLayer;
import org.planit.xml.generated.XMLElementLayerConfiguration;
import org.planit.xml.generated.XMLElementLinkLengthType;
import org.planit.xml.generated.XMLElementLinkSegment;
import org.planit.xml.generated.XMLElementLinkSegmentType;
import org.planit.xml.generated.XMLElementLinkSegmentTypes;
import org.planit.xml.generated.XMLElementLinks;
import org.planit.xml.generated.XMLElementNodes;

public class XmlMacroscopicNetworkLayerHelper {
    private static final Logger LOGGER = Logger.getLogger(XmlMacroscopicNetworkLayerHelper.class.getCanonicalName());

    protected static Double parseLengthElementFromLink(XMLElementLinks.Link generatedLink) {
        Double length = null;
        XMLElementLinkLengthType linkLengthType = generatedLink.getLength();
        if (linkLengthType != null) {
            LengthUnit lengthUnit = linkLengthType.getUnit();
            length = lengthUnit != null && lengthUnit.equals((Object)LengthUnit.M) ? Double.valueOf(linkLengthType.getValue() / 1000.0) : Double.valueOf(linkLengthType.getValue());
        }
        return length;
    }

    protected static Double parseLengthFromLineString(XMLElementLinks.Link generatedLink, PlanitJtsUtils jtsUtils) throws PlanItException {
        Double length = null;
        LineStringType lineStringType = generatedLink.getLineString();
        if (lineStringType != null) {
            List<Double> posList = lineStringType.getPosList().getValue();
            length = 0.0;
            Point startPosition = null;
            Point endPosition = null;
            for (int i = 0; i < posList.size(); i += 2) {
                endPosition = PlanitJtsUtils.createPoint(posList.get(i), posList.get(i + 1));
                if (startPosition != null) {
                    length = length + jtsUtils.getDistanceInKilometres(startPosition, endPosition);
                }
                startPosition = endPosition;
            }
        }
        return length;
    }

    protected static LineString parseLinkGeometry(XMLElementLinks.Link generatedLink) throws PlanItException {
        if (generatedLink.getLineString() != null) {
            LineStringType lst = generatedLink.getLineString();
            if (lst.getCoordinates() != null) {
                return PlanitJtsUtils.createLineStringFromCsvString(lst.getCoordinates().getValue(), lst.getCoordinates().getTs(), lst.getCoordinates().getCs());
            }
            if (lst.getPosList() != null) {
                return PlanitJtsUtils.createLineString(lst.getPosList().getValue());
            }
        }
        return null;
    }

    protected static double parseLength(XMLElementLinks.Link xmlLink, PlanitJtsUtils jtsUtils) throws PlanItException {
        Double length = XmlMacroscopicNetworkLayerHelper.parseLengthElementFromLink(xmlLink);
        if (length == null) {
            length = XmlMacroscopicNetworkLayerHelper.parseLengthFromLineString(xmlLink, jtsUtils);
        }
        if (length == null) {
            throw new PlanItException("Error in network XML file: Must define either a length or GML LineString for link from node " + xmlLink.getNodearef() + " to node " + xmlLink.getNodebref());
        }
        return length;
    }

    protected static void parseLinkSegmentTypeModeProperties(Accessmode xmlMode, MacroscopicLinkSegmentType linkSegmentType, Map<String, Mode> modesByXmlId) throws PlanItException {
        String modeXmlRefId = xmlMode.getRef();
        Mode thePlanitMode = modesByXmlId.get(modeXmlRefId);
        PlanItException.throwIfNull(thePlanitMode, String.format("referenced mode (xml id:%s) does not exist in PLANit parser", modeXmlRefId));
        double maxSpeed = thePlanitMode.getMaximumSpeedKmH();
        double critSpeed = Math.min(maxSpeed, 60.0);
        if (xmlMode != null) {
            maxSpeed = xmlMode.getMaxspeed() == null ? thePlanitMode.getMaximumSpeedKmH() : xmlMode.getMaxspeed().doubleValue();
            critSpeed = xmlMode.getCritspeed() == null ? 60.0 : xmlMode.getCritspeed();
            critSpeed = Math.min(maxSpeed, critSpeed);
        }
        linkSegmentType.addModeProperties(thePlanitMode, MacroscopicModePropertiesFactory.create(maxSpeed, critSpeed));
    }

    protected static void injectDefaultLinkSegmentType(XMLElementLayerConfiguration xmlLayerConfiguration) {
        if (xmlLayerConfiguration.getLinksegmenttypes() == null) {
            xmlLayerConfiguration.setLinksegmenttypes(new XMLElementLinkSegmentTypes());
            XMLElementLinkSegmentType xmlLinkSegmentType = new XMLElementLinkSegmentType();
            xmlLinkSegmentType.setName("");
            xmlLinkSegmentType.setId("1");
            xmlLinkSegmentType.setCapacitylane(1800.0);
            xmlLinkSegmentType.setMaxdensitylane(180.0);
            xmlLayerConfiguration.getLinksegmenttypes().getLinksegmenttype().add(xmlLinkSegmentType);
        }
    }

    public static Map<String, MacroscopicLinkSegmentType> parseLinkSegmentTypes(XMLElementLayerConfiguration xmlLayerconfiguration, MacroscopicPhysicalNetwork networkLayer, PlanitNetworkReaderSettings settings, Map<String, Mode> modesByXmlId) throws PlanItException {
        if (xmlLayerconfiguration.getLinksegmenttypes() == null) {
            XmlMacroscopicNetworkLayerHelper.injectDefaultLinkSegmentType(xmlLayerconfiguration);
        }
        if (settings.getMapToIndexLinkSegmentTypeByXmlIds() == null) {
            settings.setMapToIndexLinkSegmentTypeByXmlIds(new HashMap<String, MacroscopicLinkSegmentType>());
        }
        Map<String, MacroscopicLinkSegmentType> segmentTypeByXmlId = settings.getMapToIndexLinkSegmentTypeByXmlIds();
        List<XMLElementLinkSegmentType> xmlLinkSegmentTypes = xmlLayerconfiguration.getLinksegmenttypes().getLinksegmenttype();
        for (XMLElementLinkSegmentType xmlLinkSegmentType : xmlLinkSegmentTypes) {
            String xmlId = xmlLinkSegmentType.getId();
            if (segmentTypeByXmlId.containsKey(xmlId)) {
                throw new PlanItException("duplicate link segment type id " + xmlId + " found in network");
            }
            String externalId = null;
            if (xmlLinkSegmentType.getExternalid() != null && !xmlLinkSegmentType.getExternalid().isBlank()) {
                externalId = xmlLinkSegmentType.getExternalid();
            }
            String name = xmlLinkSegmentType.getName();
            double capacityPcuPerHour = xmlLinkSegmentType.getCapacitylane() == null ? 1800.0 : xmlLinkSegmentType.getCapacitylane();
            double maximumDensityPcuPerKm = xmlLinkSegmentType.getMaxdensitylane() == null ? 180.0 : xmlLinkSegmentType.getMaxdensitylane();
            MacroscopicLinkSegmentType linkSegmentType = networkLayer.linkSegmentTypes.createAndRegisterNew(name, capacityPcuPerHour, maximumDensityPcuPerKm);
            linkSegmentType.setXmlId(xmlId);
            linkSegmentType.setExternalId(externalId);
            segmentTypeByXmlId.put(xmlId, linkSegmentType);
            Collection thePlanitModes = new HashSet();
            if (xmlLinkSegmentType.getAccess() != null) {
                List<Accessmode> xmlModes = xmlLinkSegmentType.getAccess().getMode();
                for (Accessmode xmlMode : xmlModes) {
                    XmlMacroscopicNetworkLayerHelper.parseLinkSegmentTypeModeProperties(xmlMode, linkSegmentType, modesByXmlId);
                }
                continue;
            }
            thePlanitModes = modesByXmlId.values().stream().filter(mode -> mode.getPhysicalFeatures().getTrackType() == TrackModeType.ROAD).collect(Collectors.toSet());
            thePlanitModes.forEach(planitMode -> linkSegmentType.addModeProperties((Mode)planitMode, MacroscopicModePropertiesFactory.create(planitMode.getMaximumSpeedKmH())));
        }
        return segmentTypeByXmlId;
    }

    public static Map<String, Node> parseNodes(XMLElementInfrastructureLayer xmlLayer, MacroscopicPhysicalNetwork networkLayer, PlanitNetworkReaderSettings settings) throws PlanItException {
        if (settings.getMapToIndexNodeByXmlIds() == null) {
            settings.setMapToIndexNodeByXmlIds(new HashMap<String, Node>());
        }
        Map<String, Node> nodesByXmlId = settings.getMapToIndexNodeByXmlIds();
        for (XMLElementNodes.Node xmlNode : xmlLayer.getNodes().getNode()) {
            Node prevValue;
            PointType pointType;
            Node node = (Node)networkLayer.nodes.registerNew();
            if (xmlNode.getId() != null && !xmlNode.getId().isBlank()) {
                node.setXmlId(xmlNode.getId());
            }
            if (xmlNode.getExternalid() != null && !xmlNode.getExternalid().isBlank()) {
                node.setExternalId(xmlNode.getExternalid());
            }
            if ((pointType = xmlNode.getPoint()) != null) {
                List<Double> posValues = pointType.getPos().getValue();
                Point centrePointGeometry = PlanitJtsUtils.createPoint(posValues.get(0), posValues.get(1));
                node.setPosition(centrePointGeometry);
            }
            if ((prevValue = nodesByXmlId.put(node.getXmlId(), node)) == null) continue;
            throw new PlanItException("Duplicate node external id " + node.getXmlId() + " found in network file");
        }
        return nodesByXmlId;
    }

    public static void parseLinkAndLinkSegments(XMLElementInfrastructureLayer xmlLayer, MacroscopicPhysicalNetwork networkLayer, PlanitNetworkReaderSettings settings, Map<String, Node> nodesByXmlId, Map<String, MacroscopicLinkSegmentType> linkSegmentTypesByXmlId, PlanitJtsUtils jtsUtils) throws PlanItException {
        if (settings.getMapToIndexLinkSegmentByXmlIds() == null) {
            settings.setMapToIndexLinkSegmentByXmlIds(new HashMap<String, MacroscopicLinkSegment>());
        }
        Map<String, MacroscopicLinkSegment> linkSegmentsByXmlId = settings.getMapToIndexLinkSegmentByXmlIds();
        XMLElementLinks xmlLinks = xmlLayer.getLinks();
        PlanItException.throwIfNull(xmlLinks, "links xml element missing");
        for (XMLElementLinks.Link xmlLink : xmlLinks.getLink()) {
            Link link = null;
            Node startNode = nodesByXmlId.get(xmlLink.getNodearef());
            Node endNode = nodesByXmlId.get(xmlLink.getNodebref());
            double length = XmlMacroscopicNetworkLayerHelper.parseLength(xmlLink, jtsUtils);
            link = (Link)networkLayer.links.registerNew(startNode, endNode, length);
            LineString theLineString = XmlMacroscopicNetworkLayerHelper.parseLinkGeometry(xmlLink);
            link.setGeometry(theLineString);
            if (xmlLink.getId() != null && !xmlLink.getId().isBlank()) {
                link.setXmlId(xmlLink.getId());
            } else {
                LOGGER.fine(String.format("link id absent, generating internal id instead (node a: %s, node b: %s)", link.getNodeA().getXmlId(), link.getNodeB().getXmlId()));
                link.setXmlId(String.valueOf(link.getId()));
            }
            if (xmlLink.getExternalid() != null && !xmlLink.getExternalid().isBlank()) {
                link.setExternalId(xmlLink.getExternalid());
            }
            boolean isFirstLinkSegment = true;
            boolean firstLinkDirection = true;
            for (XMLElementLinkSegment xmlLinkSegment : xmlLink.getLinksegment()) {
                boolean abDirection = xmlLinkSegment.getDir().equals((Object)Direction.A_B);
                if (!isFirstLinkSegment && abDirection == firstLinkDirection) {
                    throw new PlanItException("Both link segments for the same link are in the same direction.  Link segment external Id is " + xmlLinkSegment.getId());
                }
                MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)networkLayer.linkSegments.registerNew(link, abDirection, true);
                if (xmlLinkSegment.getId() != null && !xmlLinkSegment.getId().isBlank()) {
                    linkSegment.setXmlId(xmlLinkSegment.getId());
                } else {
                    LOGGER.warning("link segment has no xml id, applying internal id instead");
                    linkSegment.setXmlId(Long.toString(linkSegment.getId()));
                }
                if (xmlLinkSegment.getExternalid() != null && !xmlLinkSegment.getExternalid().isBlank()) {
                    linkSegment.setExternalId(xmlLinkSegment.getExternalid());
                }
                double maxSpeed = xmlLinkSegment.getMaxspeed() == null ? Double.POSITIVE_INFINITY : xmlLinkSegment.getMaxspeed();
                linkSegment.setPhysicalSpeedLimitKmH(maxSpeed);
                int noLanes = xmlLinkSegment.getNumberoflanes() == null ? 1 : xmlLinkSegment.getNumberoflanes().intValue();
                linkSegment.setNumberOfLanes(noLanes);
                MacroscopicLinkSegment duplicate = linkSegmentsByXmlId.put(linkSegment.getXmlId(), linkSegment);
                if (duplicate != null) {
                    throw new PlanItException("Duplicate link segment xml id " + linkSegment.getXmlId() + " found in network");
                }
                String linkSegmentTypeXmlId = null;
                if (xmlLinkSegment.getTyperef() == null) {
                    if (linkSegmentTypesByXmlId.keySet().size() > 1) {
                        throw new PlanItException("Link Segment " + xmlLinkSegment.getId() + " has no link segment type defined, but there is more than one possible link segment type");
                    }
                    linkSegmentTypeXmlId = networkLayer.linkSegmentTypes.getFirst().getXmlId();
                } else {
                    linkSegmentTypeXmlId = xmlLinkSegment.getTyperef();
                }
                MacroscopicLinkSegmentType linkSegmentType = linkSegmentTypesByXmlId.get(linkSegmentTypeXmlId);
                if (linkSegmentType == null) {
                    throw new PlanItException(String.format("link segment type %s, unknown, cannot be registered on link segment %s", linkSegmentsByXmlId, linkSegment));
                }
                linkSegment.setLinkSegmentType(linkSegmentType);
                isFirstLinkSegment = false;
                firstLinkDirection = abDirection;
            }
        }
    }
}

