/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.util;

import java.io.File;
import org.planit.io.xml.util.JAXBUtils;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.FileUtils;

public class PlanitXmlReader<T> {
    private final String networkPathDirectory;
    private final String xmlFileExtension;
    private Class<T> clazz;
    private T xmlRootElement;

    protected T initialiseAndParseXmlRootElement() throws PlanItException {
        if (this.xmlRootElement == null) {
            File[] xmlFileNames = FileUtils.getFilesWithExtensionFromDir(this.networkPathDirectory, this.xmlFileExtension);
            PlanItException.throwIf(xmlFileNames.length == 0, String.format("Directory %s contains no files with extension %s", this.networkPathDirectory, this.xmlFileExtension));
            return JAXBUtils.generateInstanceFromXml(this.clazz, xmlFileNames);
        }
        return this.xmlRootElement;
    }

    protected T getXmlRootElement() {
        return this.xmlRootElement;
    }

    public PlanitXmlReader(Class<T> clazz, String networkPathDirectory, String xmlFileExtension) {
        this.clazz = clazz;
        this.xmlRootElement = null;
        this.xmlFileExtension = null;
        this.networkPathDirectory = null;
    }

    public PlanitXmlReader(T xmlRootElement) {
        this.clazz = null;
        this.xmlRootElement = xmlRootElement;
        this.xmlFileExtension = null;
        this.networkPathDirectory = null;
    }

    public void clearXmlContent() {
        this.xmlRootElement = null;
    }
}

