/*
 * Decompiled with CFR 0.152.
 */
package org.planit.mode;

import org.planit.mode.BicycleMode;
import org.planit.mode.BusMode;
import org.planit.mode.CarHighOccupancyMode;
import org.planit.mode.CarMode;
import org.planit.mode.CarShareMode;
import org.planit.mode.GoodsMode;
import org.planit.mode.HeavyGoodsMode;
import org.planit.mode.LargeHeavyGoodsMode;
import org.planit.mode.LightRailMode;
import org.planit.mode.MotorBikeMode;
import org.planit.mode.PedestrianMode;
import org.planit.mode.SubwayMode;
import org.planit.mode.TrainMode;
import org.planit.mode.TramMode;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.PredefinedMode;
import org.planit.utils.mode.PredefinedModeType;

public class ModeFactory {
    public static PredefinedMode createPredefinedMode(IdGroupingToken groupId, PredefinedModeType modeType) throws PlanItException {
        switch (modeType) {
            case BICYCLE: {
                return new BicycleMode(groupId);
            }
            case BUS: {
                return new BusMode(groupId);
            }
            case CAR: {
                return new CarMode(groupId);
            }
            case CAR_SHARE: {
                return new CarShareMode(groupId);
            }
            case CAR_HIGH_OCCUPANCY: {
                return new CarHighOccupancyMode(groupId);
            }
            case GOODS_VEHICLE: {
                return new GoodsMode(groupId);
            }
            case HEAVY_GOODS_VEHICLE: {
                return new HeavyGoodsMode(groupId);
            }
            case LARGE_HEAVY_GOODS_VEHICLE: {
                return new LargeHeavyGoodsMode(groupId);
            }
            case LIGHTRAIL: {
                return new LightRailMode(groupId);
            }
            case MOTOR_BIKE: {
                return new MotorBikeMode(groupId);
            }
            case PEDESTRIAN: {
                return new PedestrianMode(groupId);
            }
            case SUBWAY: {
                return new SubwayMode(groupId);
            }
            case TRAIN: {
                return new TrainMode(groupId);
            }
            case TRAM: {
                return new TramMode(groupId);
            }
        }
        throw new PlanItException(String.format("mode type %s unknown", new Object[]{modeType}));
    }
}

