/*
 * Decompiled with CFR 0.152.
 */
package org.planit.mode;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.mode.ModeFactory;
import org.planit.mode.ModeImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.Modes;
import org.planit.utils.mode.PhysicalModeFeatures;
import org.planit.utils.mode.PredefinedMode;
import org.planit.utils.mode.PredefinedModeType;
import org.planit.utils.mode.UsabilityModeFeatures;

public class ModesImpl
implements Modes {
    private static final Logger LOGGER = Logger.getLogger(ModesImpl.class.getCanonicalName());
    private final Map<Long, Mode> modeMap = new TreeMap<Long, Mode>();
    private final IdGroupingToken groupId;

    public ModesImpl(IdGroupingToken groupId) {
        this.groupId = groupId;
    }

    protected Mode register(Mode mode) {
        return this.modeMap.put(mode.getId(), mode);
    }

    @Override
    public Iterator<Mode> iterator() {
        return this.modeMap.values().iterator();
    }

    @Override
    public Mode registerNewCustomMode(String name, double maxSpeed, double pcu, PhysicalModeFeatures physicalFeatures, UsabilityModeFeatures usabilityFeatures) {
        ModeImpl newMode = new ModeImpl(this.groupId, name, maxSpeed, pcu, physicalFeatures, usabilityFeatures);
        this.register(newMode);
        return newMode;
    }

    @Override
    public PredefinedMode registerNew(PredefinedModeType modeType) throws PlanItException {
        PredefinedMode theMode = null;
        if (!this.containsPredefinedMode(modeType)) {
            theMode = ModeFactory.createPredefinedMode(this.groupId, modeType);
            this.register(theMode);
        } else {
            theMode = this.get(modeType);
        }
        return theMode;
    }

    @Override
    public int size() {
        return this.modeMap.size();
    }

    @Override
    public Mode get(long id) {
        return this.modeMap.get(id);
    }

    @Override
    public boolean containsPredefinedMode(PredefinedModeType modeType) {
        return this.modeMap.values().stream().anyMatch(mode -> mode instanceof PredefinedMode && mode.getName().equals(modeType.value()));
    }

    @Override
    public PredefinedMode get(PredefinedModeType modeType) {
        return (PredefinedMode)this.modeMap.values().stream().dropWhile(mode -> !(mode instanceof PredefinedMode) || !mode.getName().equals(modeType.value())).findFirst().get();
    }

    @Override
    public Mode getFirst() {
        return this.get(0L);
    }

    @Override
    public Mode getByXmlId(String xmlId) {
        for (Mode mode : this.modeMap.values()) {
            if (!xmlId.equals(mode.getXmlId())) continue;
            return mode;
        }
        return null;
    }

    @Override
    public Set<Mode> setOf() {
        return Set.copyOf(this.modeMap.values());
    }
}

