/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network;

import java.util.Collection;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.mode.Mode;

public interface InfrastructureLayer
extends ExternalIdable {
    public static String createLayerLogPrefix(InfrastructureLayer layer) {
        return String.format("[LAYER: %s ]", layer.getXmlId());
    }

    public boolean registerSupportedMode(Mode var1);

    public boolean registerSupportedModes(Collection<Mode> var1);

    public Collection<Mode> getSupportedModes();

    default public boolean supports(Mode mode) {
        return this.getSupportedModes().contains(mode);
    }

    public boolean isEmpty();

    public void logInfo(String var1);

    public boolean validate();

    public void transform(CoordinateReferenceSystem var1, CoordinateReferenceSystem var2) throws PlanItException;

    default public void removeDanglingSubnetworks() throws PlanItException {
        this.removeDanglingSubnetworks(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    public void removeDanglingSubnetworks(Integer var1, Integer var2, boolean var3) throws PlanItException;
}

