/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.planit.network.InfrastructureLayer;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;

public abstract class InfrastructureLayerImpl
implements InfrastructureLayer {
    protected long id;
    protected String xmlId;
    protected String externalId;
    protected final Map<Long, Mode> supportedModes = new TreeMap<Long, Mode>();

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId(tokenId, InfrastructureLayerImpl.class);
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public InfrastructureLayerImpl(IdGroupingToken tokenId) {
        this.setId(InfrastructureLayerImpl.generateId(tokenId));
        this.xmlId = null;
        this.externalId = null;
    }

    @Override
    public boolean registerSupportedMode(Mode supportedMode) {
        if (supportedMode != null) {
            this.supportedModes.put(supportedMode.getId(), supportedMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean registerSupportedModes(Collection<Mode> supportedModes) {
        boolean success = false;
        if (supportedModes != null && supportedModes.size() > 0) {
            success = true;
            for (Mode mode : supportedModes) {
                if (this.registerSupportedMode(mode)) continue;
                success = false;
            }
        }
        return success;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    @Override
    public final Collection<Mode> getSupportedModes() {
        return this.supportedModes.values();
    }
}

