/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network;

import java.util.logging.Logger;
import org.apache.commons.collections4.map.HashedMap;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.geo.PlanitJtsUtils;
import org.planit.mode.ModesImpl;
import org.planit.network.InfraStructureLayersImpl;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureLayers;
import org.planit.network.InfrastructureLayersConfigurator;
import org.planit.network.Network;
import org.planit.network.macroscopic.physical.MacroscopicPhysicalNetwork;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.mode.Modes;

public class InfrastructureNetwork
extends Network {
    private static final long serialVersionUID = 2402806336978560448L;
    private static final Logger LOGGER = Logger.getLogger(InfrastructureNetwork.class.getCanonicalName());
    public final Modes modes;
    public final InfrastructureLayers infrastructureLayers;
    private CoordinateReferenceSystem coordinateReferenceSystem;

    public InfrastructureNetwork(IdGroupingToken tokenId) {
        this(tokenId, PlanitJtsUtils.DEFAULT_GEOGRAPHIC_CRS);
    }

    public InfrastructureNetwork(IdGroupingToken tokenId, CoordinateReferenceSystem coordinateReferenceSystem) {
        super(tokenId);
        this.modes = new ModesImpl(tokenId);
        this.infrastructureLayers = new InfraStructureLayersImpl(this.getNetworkGroupingTokenId());
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.infrastructureLayers.isEachLayerEmpty()) {
            this.coordinateReferenceSystem = coordinateReferenceSystem;
        } else {
            LOGGER.warning("Coordinate Reference System is already set. To change the CRS after instantiation, use transform() method");
        }
    }

    public void transform(CoordinateReferenceSystem newCoordinateReferenceSystem) throws PlanItException {
        for (InfrastructureLayer layer : this.infrastructureLayers) {
            layer.transform(this.coordinateReferenceSystem, newCoordinateReferenceSystem);
        }
    }

    public InfrastructureLayer getInfrastructureLayerByMode(Mode mode) {
        return this.infrastructureLayers.get(mode);
    }

    public void initialiseInfrastructureLayers(InfrastructureLayersConfigurator planitInfrastructureLayerConfiguration) {
        if (!this.infrastructureLayers.isNoLayers()) {
            LOGGER.warning("unable to initialise infrastructure layers based on provided configuration, since network already has layers defined");
            return;
        }
        HashedMap<String, Long> xmlIdToId = new HashedMap<String, Long>();
        for (String layerXmlId2 : planitInfrastructureLayerConfiguration.infrastructureLayersByXmlId) {
            MacroscopicPhysicalNetwork newLayer = this.infrastructureLayers.createNew();
            newLayer.setXmlId(layerXmlId2);
            xmlIdToId.put(layerXmlId2, newLayer.getId());
        }
        planitInfrastructureLayerConfiguration.modeToLayerXmlId.forEach((mode, layerXmlId) -> this.infrastructureLayers.get((Long)xmlIdToId.get(layerXmlId)).registerSupportedMode((Mode)mode));
    }

    public void removeDanglingSubnetworks() throws PlanItException {
        this.removeDanglingSubnetworks(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    public void removeDanglingSubnetworks(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) throws PlanItException {
        for (InfrastructureLayer infrastructureLayer : this.infrastructureLayers) {
            infrastructureLayer.removeDanglingSubnetworks(belowSize, aboveSize, alwaysKeepLargest);
        }
    }
}

