/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.converter;

import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.geo.PlanitOpenGisUtils;
import org.planit.network.converter.IdMapperType;
import org.planit.network.converter.NetworkWriter;
import org.planit.utils.epsg.EpsgCodesByCountry;
import org.planit.utils.exceptions.PlanItException;

public abstract class NetworkWriterImpl
implements NetworkWriter {
    protected IdMapperType idMapper;

    protected CoordinateReferenceSystem identifyDestinationCoordinateReferenceSystem(CoordinateReferenceSystem overwriteCrs, String countryName, CoordinateReferenceSystem fallBackCrs) throws PlanItException {
        CoordinateReferenceSystem destinationCrs = overwriteCrs;
        if (destinationCrs == null) {
            destinationCrs = PlanitOpenGisUtils.createCoordinateReferenceSystem(EpsgCodesByCountry.getEpsg(countryName));
        }
        if (destinationCrs == null) {
            destinationCrs = fallBackCrs;
        }
        PlanItException.throwIfNull(destinationCrs, "destination Coordinate Reference System is null, this is not allowed");
        return destinationCrs;
    }

    protected NetworkWriterImpl(IdMapperType idMapperType) {
        this.setIdMapperType(idMapperType);
    }

    @Override
    public IdMapperType getIdMapperType() {
        return this.idMapper;
    }

    @Override
    public void setIdMapperType(IdMapperType idMapper) {
        this.idMapper = idMapper;
    }
}

