/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.planit.network.Network;
import org.planit.network.virtual.ConnectoidEdgeImpl;
import org.planit.network.virtual.ConnectoidSegmentImpl;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.ConnectoidEdge;
import org.planit.utils.network.virtual.ConnectoidSegment;
import org.planit.utils.zoning.Connectoid;
import org.planit.utils.zoning.DirectedConnectoid;
import org.planit.utils.zoning.UndirectedConnectoid;
import org.planit.utils.zoning.Zone;

public class VirtualNetwork
extends Network {
    private static final long serialVersionUID = -4088201905917614130L;
    protected Map<Long, ConnectoidEdge> connectoidEdgeMap = new TreeMap<Long, ConnectoidEdge>();
    protected Map<Long, ConnectoidSegment> connectoidSegmentMap = new TreeMap<Long, ConnectoidSegment>();
    public final ConnectoidEdges connectoidEdges = new ConnectoidEdges();
    public final ConnectoidSegments connectoidSegments = new ConnectoidSegments();

    public VirtualNetwork(IdGroupingToken tokenId) {
        super(tokenId);
    }

    public void clear() {
        this.connectoidEdgeMap.clear();
        this.connectoidSegmentMap.clear();
    }

    public class ConnectoidSegments
    implements Iterable<ConnectoidSegment> {
        protected ConnectoidSegment registerConnectoidSegment(ConnectoidSegment connectoidSegment) {
            return VirtualNetwork.this.connectoidSegmentMap.put(connectoidSegment.getId(), connectoidSegment);
        }

        @Override
        public Iterator<ConnectoidSegment> iterator() {
            return VirtualNetwork.this.connectoidSegmentMap.values().iterator();
        }

        public ConnectoidSegment createAndRegisterConnectoidSegment(ConnectoidEdge parent, boolean directionAB) throws PlanItException {
            ConnectoidSegmentImpl connectoidSegment = new ConnectoidSegmentImpl(VirtualNetwork.this.getIdGroupingToken(), parent, directionAB);
            parent.registerConnectoidSegment(connectoidSegment, directionAB);
            this.registerConnectoidSegment(connectoidSegment);
            return connectoidSegment;
        }

        public ConnectoidSegment getConnectoidSegment(long id) {
            return VirtualNetwork.this.connectoidSegmentMap.get(id);
        }

        public int getNumberOfConnectoidSegments() {
            return VirtualNetwork.this.connectoidSegmentMap.size();
        }
    }

    public class ConnectoidEdges
    implements Iterable<ConnectoidEdge> {
        protected ConnectoidEdge register(ConnectoidEdge connectoidEdge) {
            return VirtualNetwork.this.connectoidEdgeMap.put(connectoidEdge.getId(), connectoidEdge);
        }

        public Collection<ConnectoidEdge> registerNew(Connectoid connectoid) throws PlanItException {
            ArrayList<ConnectoidEdge> connectoidEdges = new ArrayList<ConnectoidEdge>();
            for (Zone accessZone : connectoid) {
                Node accessNode = null;
                if (connectoid instanceof UndirectedConnectoid) {
                    accessNode = ((UndirectedConnectoid)UndirectedConnectoid.class.cast(connectoid)).getAccessNode();
                } else if (connectoid instanceof DirectedConnectoid) {
                    LinkSegment accessEdgeSegment = ((DirectedConnectoid)DirectedConnectoid.class.cast(connectoid)).getAccessLinkSegment();
                    accessNode = (Node)(accessEdgeSegment != null ? accessEdgeSegment.getDownstreamVertex() : null);
                } else {
                    throw new PlanItException(String.format("connectoid %s is of unrecognised type and access node could not be retrieved", connectoid.getXmlId()));
                }
                ConnectoidEdgeImpl newConnectoidEdge = new ConnectoidEdgeImpl(VirtualNetwork.this.getIdGroupingToken(), accessZone.getCentroid(), accessNode, (double)connectoid.getLength(accessZone));
                this.register(newConnectoidEdge);
                connectoidEdges.add(newConnectoidEdge);
            }
            return connectoidEdges;
        }

        public ConnectoidEdge get(long id) {
            return VirtualNetwork.this.connectoidEdgeMap.get(id);
        }

        public int size() {
            return VirtualNetwork.this.connectoidEdgeMap.size();
        }

        @Override
        public Iterator<ConnectoidEdge> iterator() {
            return VirtualNetwork.this.connectoidEdgeMap.values().iterator();
        }
    }
}

