/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.formatter;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odpath.ODPathIterator;
import org.planit.od.odpath.ODPathMatrix;
import org.planit.output.adapter.LinkOutputTypeAdapter;
import org.planit.output.adapter.ODOutputTypeAdapter;
import org.planit.output.adapter.OutputAdapter;
import org.planit.output.adapter.PathOutputTypeAdapter;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.configuration.PathOutputTypeConfiguration;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.OutputTypeEnum;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.formatter.FileOutputFormatter;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.output.OutputUtils;

public abstract class CsvFileOutputFormatter
extends FileOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(CsvFileOutputFormatter.class.getCanonicalName());
    protected final Map<OutputTypeEnum, List<String>> csvFileNameMap = new HashMap<OutputTypeEnum, List<String>>();

    protected CsvFileOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    protected PlanItException writeOdResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            ODOutputTypeAdapter odOutputTypeAdapter = (ODOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputTypeConfiguration.getOutputType());
            SortedSet<BaseOutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            PlanItException.throwIf(!(currentOutputType instanceof SubOutputTypeEnum) || !((SubOutputTypeEnum)currentOutputType instanceof ODSkimSubOutputType), "currentOutputType is not compatible with od results");
            ODSkimSubOutputType currentSubOutputType = (ODSkimSubOutputType)currentOutputType;
            for (Mode mode : modes) {
                ODSkimMatrix odSkimMatrix = odOutputTypeAdapter.getODSkimMatrix(currentSubOutputType, mode);
                ODMatrixIterator odMatrixIterator = odSkimMatrix.iterator();
                while (odMatrixIterator.hasNext()) {
                    odMatrixIterator.next();
                    if (!outputConfiguration.isPersistZeroFlow() && !((Double)odOutputTypeAdapter.getODOutputPropertyValue(OutputProperty.OD_COST, odMatrixIterator, mode, timePeriod, this.outputTimeUnit.getMultiplier()) > 0.0)) continue;
                    List rowValues = outputProperties.stream().map(outputProperty -> odOutputTypeAdapter.getODOutputPropertyValue(outputProperty.getOutputProperty(), odMatrixIterator, mode, timePeriod, this.outputTimeUnit.getMultiplier())).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                    csvPrinter.printRecord(rowValues);
                }
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing od results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected PlanItException writePathResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            PlanItException.throwIf(!(currentOutputType instanceof OutputType), "currentOutputType not compatible with path output");
            OutputType outputType = (OutputType)currentOutputType;
            PathOutputTypeAdapter pathOutputTypeAdapter = (PathOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
            PathOutputTypeConfiguration pathOutputTypeConfiguration = (PathOutputTypeConfiguration)outputTypeConfiguration;
            SortedSet<BaseOutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            for (Mode mode : modes) {
                ODPathMatrix odPathMatrix = pathOutputTypeAdapter.getODPathMatrix(mode);
                ODPathIterator odPathIterator = odPathMatrix.iterator();
                while (odPathIterator.hasNext()) {
                    odPathIterator.next();
                    if (!outputConfiguration.isPersistZeroFlow() && odPathIterator.getCurrentValue() == null) continue;
                    List rowValues = outputProperties.stream().map(outputProperty -> pathOutputTypeAdapter.getPathOutputPropertyValue(outputProperty.getOutputProperty(), odPathIterator, mode, timePeriod, pathOutputTypeConfiguration.getPathIdentificationType())).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                    csvPrinter.printRecord(rowValues);
                }
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing path results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected PlanItException writeLinkResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            PlanItException.throwIf(!(currentOutputType instanceof OutputType), "currentOutputType not compatible with link output");
            OutputType outputType = (OutputType)currentOutputType;
            LinkOutputTypeAdapter linkOutputTypeAdapter = (LinkOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
            SortedSet<BaseOutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            for (Mode mode : modes) {
                Long networkLayerId = linkOutputTypeAdapter.getInfrastructureLayerIdForMode(mode);
                if (networkLayerId != null) {
                    for (LinkSegment linkSegment : linkOutputTypeAdapter.getPhysicalLinkSegments(networkLayerId)) {
                        if (!outputConfiguration.isPersistZeroFlow() && !linkOutputTypeAdapter.isFlowPositive(linkSegment, mode)) continue;
                        List rowValues = outputProperties.stream().map(outputProperty -> linkOutputTypeAdapter.getLinkOutputPropertyValue(outputProperty.getOutputProperty(), linkSegment, mode, timePeriod, this.outputTimeUnit.getMultiplier())).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                        csvPrinter.printRecord(rowValues);
                    }
                    continue;
                }
                LOGGER.severe(String.format("network layer could not be identified for mode %s by csv output formatter", mode.getXmlId()));
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing link results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected CSVPrinter openCsvFileAndWriteHeaders(OutputTypeConfiguration outputTypeConfiguration, String csvFileName) throws Exception {
        CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(csvFileName), CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        List headerValues = outputTypeConfiguration.getOutputProperties().stream().map(BaseOutputProperty::getName).collect(Collectors.toList());
        csvPrinter.printRecord(headerValues);
        return csvPrinter;
    }

    public void addCsvFileNamePerOutputType(OutputTypeEnum currentoutputType, String csvFileName) {
        if (!this.csvFileNameMap.containsKey(currentoutputType)) {
            this.csvFileNameMap.put(currentoutputType, new ArrayList());
        }
        this.csvFileNameMap.get(currentoutputType).add(csvFileName);
    }
}

