/*
 * Decompiled with CFR 0.152.
 */
package org.planit.path.choice;

import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.input.InputBuilderListener;
import org.planit.path.choice.PathChoiceBuilder;
import org.planit.path.choice.StochasticPathChoice;
import org.planit.path.choice.StochasticPathChoiceConfigurator;
import org.planit.path.choice.logit.LogitChoiceModel;
import org.planit.utils.builder.Configurator;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;

public class StochasticPathChoiceBuilder
extends PathChoiceBuilder<StochasticPathChoice> {
    protected static final Logger LOGGER = Logger.getLogger(StochasticPathChoiceBuilder.class.getCanonicalName());

    @Override
    protected Configurator<StochasticPathChoice> createConfigurator() throws PlanItException {
        return new StochasticPathChoiceConfigurator();
    }

    protected LogitChoiceModel createLogitChoiceModelInstance(StochasticPathChoiceConfigurator configurator) throws PlanItException {
        TrafficAssignmentComponentFactory logitChoiceModelFactory = new TrafficAssignmentComponentFactory(LogitChoiceModel.class);
        logitChoiceModelFactory.addListener(this.getInputBuilderListener(), TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        return (LogitChoiceModel)logitChoiceModelFactory.create(configurator.getLogitModel().getClassTypeToConfigure().getCanonicalName(), new Object[]{this.getGroupIdToken()});
    }

    @Override
    protected void buildSubComponents(StochasticPathChoice pathChoiceInstance) throws PlanItException {
        StochasticPathChoiceConfigurator configurator = (StochasticPathChoiceConfigurator)this.getConfigurator();
        if (configurator.getLogitModel() != null) {
            LogitChoiceModel logitModel = this.createLogitChoiceModelInstance(configurator);
            configurator.getLogitModel().configure(logitModel);
            pathChoiceInstance.setLogitModel(logitModel);
        }
    }

    public StochasticPathChoiceBuilder(IdGroupingToken projectToken, InputBuilderListener inputBuilderListener) throws PlanItException {
        super(StochasticPathChoice.class, projectToken, inputBuilderListener);
    }
}

