/*
 * Decompiled with CFR 0.152.
 */
package org.planit.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.assignment.TrafficAssignmentComponentFactory;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.InfrastructureLayer;
import org.planit.network.InfrastructureNetwork;
import org.planit.network.Network;
import org.planit.path.ODPathSets;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.zoning.Zoning;

public class PlanItProjectInput {
    private static final Logger LOGGER = Logger.getLogger(PlanItProjectInput.class.getCanonicalName());
    private final IdGroupingToken projectGroupId;
    private final long projectId;
    protected final TreeMap<Long, InfrastructureNetwork> infrastructureNetworkMap;
    protected final TreeMap<Long, Demands> demandsMap;
    protected final TreeMap<Long, ODPathSets> odPathSetsMap;
    protected final TreeMap<Long, Zoning> zoningsMap;
    protected final Map<InfrastructureNetwork, List<InitialLinkSegmentCost>> initialLinkSegmentCosts = new HashMap<InfrastructureNetwork, List<InitialLinkSegmentCost>>();
    protected TrafficAssignmentComponentFactory<Network> infrastructureNetworkFactory;
    protected TrafficAssignmentComponentFactory<Demands> demandsFactory;
    protected TrafficAssignmentComponentFactory<Zoning> zoningFactory;
    protected TrafficAssignmentComponentFactory<ODPathSets> odPathSetsFactory;
    protected TrafficAssignmentComponentFactory<InitialPhysicalCost> initialPhysicalCostFactory;
    public final ProjectNetworks physicalNetworks = new ProjectNetworks();
    public final ProjectDemands demands = new ProjectDemands();
    public final ProjectZonings zonings = new ProjectZonings();
    public final ProjectODPathSets odPathSets = new ProjectODPathSets();

    private void initialiseFactories(InputBuilderListener inputBuilderListener) {
        this.initialPhysicalCostFactory = new TrafficAssignmentComponentFactory(InitialPhysicalCost.class);
        this.infrastructureNetworkFactory = new TrafficAssignmentComponentFactory(Network.class.getCanonicalName());
        this.zoningFactory = new TrafficAssignmentComponentFactory(Zoning.class);
        this.demandsFactory = new TrafficAssignmentComponentFactory(Demands.class);
        this.infrastructureNetworkFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.zoningFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.demandsFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.initialPhysicalCostFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
    }

    public PlanItProjectInput(long projectId, IdGroupingToken projectGroupId, InputBuilderListener inputBuilderListener) {
        this.projectId = projectId;
        this.infrastructureNetworkMap = new TreeMap();
        this.demandsMap = new TreeMap();
        this.zoningsMap = new TreeMap();
        this.odPathSetsMap = new TreeMap();
        this.projectGroupId = projectGroupId;
        this.initialiseFactories(inputBuilderListener);
    }

    public InfrastructureNetwork createAndRegisterInfrastructureNetwork(String infrastructureNetworkType) throws PlanItException {
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating network");
        Network theNetwork = this.infrastructureNetworkFactory.create(infrastructureNetworkType, new Object[]{this.projectGroupId});
        if (!(theNetwork instanceof InfrastructureNetwork)) {
            throw new PlanItException("we currently only support networks derived from InfrastructureNetwork");
        }
        InfrastructureNetwork infrastructureNetwork = (InfrastructureNetwork)theNetwork;
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createNetworkPrefix(infrastructureNetwork.getId());
        LOGGER.info(String.format("%s#modes: %d", prefix, infrastructureNetwork.modes.size()));
        for (InfrastructureLayer networkLayer : infrastructureNetwork.infrastructureLayers) {
            networkLayer.logInfo(prefix);
        }
        this.infrastructureNetworkMap.put(infrastructureNetwork.getId(), infrastructureNetwork);
        return infrastructureNetwork;
    }

    public Zoning createAndRegisterZoning(InfrastructureNetwork infrastructureNetwork) throws PlanItException {
        PlanItException.throwIf(infrastructureNetwork == null, "The physical network must be defined before definition of zones can begin");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating zoning");
        Zoning zoning = this.zoningFactory.create(Zoning.class.getCanonicalName(), new Object[]{this.projectGroupId, infrastructureNetwork.getNetworkGroupingTokenId()}, infrastructureNetwork);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createZoningPrefix(zoning.getId());
        LOGGER.info(String.format("%s#od zones: %d (#centroids: %d)", prefix, zoning.odZones.size(), zoning.odZones.getNumberOfCentroids()));
        LOGGER.info(String.format("%s#connectoids: %d", prefix, zoning.getVirtualNetwork().connectoidEdges.size()));
        LOGGER.info(String.format("%s#connectoid segments: %d", prefix, zoning.getVirtualNetwork().connectoidSegments.getNumberOfConnectoidSegments()));
        if (!zoning.transferZones.isEmpty()) {
            LOGGER.info(String.format("%s#transfer zones: %d (#centroids:", prefix, zoning.transferZones.size(), zoning.transferZones.getNumberOfCentroids()));
        }
        this.zoningsMap.put(zoning.getId(), zoning);
        return zoning;
    }

    public Demands createAndRegisterDemands(Zoning zoning, InfrastructureNetwork network) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of demands can begin");
        PlanItException.throwIf(network == null, "network must be defined before definition of demands can begin");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating demands");
        Demands demands = this.demandsFactory.create(Demands.class.getCanonicalName(), new Object[]{this.projectGroupId}, zoning, network);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createDemandsPrefix(demands.getId());
        LOGGER.info(String.format("%s#time periods: %d", prefix, demands.timePeriods.getNumberOfTimePeriods()));
        LOGGER.info(String.format("%s#traveler types: %d", prefix, demands.travelerTypes.getNumberOfTravelerTypes()));
        LOGGER.info(String.format("%s#user classes: %d", prefix, demands.userClasses.size()));
        this.demandsMap.put(demands.getId(), demands);
        return demands;
    }

    public ODPathSets createAndRegisterOdPathSets(InfrastructureLayer networkLayer, Zoning zoning, String odPathSetInputPath) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of od path sets can proceed");
        PlanItException.throwIf(networkLayer == null, "Physical network must be defined before of od path sets can proceed");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating od path sets");
        ODPathSets odPathSets = this.odPathSetsFactory.create(ODPathSets.class.getCanonicalName(), new Object[]{this.projectGroupId}, odPathSetInputPath);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createOdPathSetsPrefix(odPathSets.getId());
        LOGGER.info(String.format("%s#od path sets: %d", prefix, odPathSets.getNumberOfOdPathSets()));
        this.odPathSetsMap.put(odPathSets.getId(), odPathSets);
        return odPathSets;
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating initial link segment costs");
        InitialLinkSegmentCost initialLinkSegmentCost = (InitialLinkSegmentCost)this.initialPhysicalCostFactory.create(InitialLinkSegmentCost.class.getCanonicalName(), new Object[]{this.projectGroupId}, network, fileName);
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCost);
        return initialLinkSegmentCost;
    }

    public InitialLinkSegmentCostPeriod createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName, TimePeriod timePeriod) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createTimePeriodPrefix(timePeriod.getExternalId(), timePeriod.getId()) + "populating initial link segment costs");
        InitialLinkSegmentCostPeriod initialLinkSegmentCostPeriod = (InitialLinkSegmentCostPeriod)this.initialPhysicalCostFactory.create(InitialLinkSegmentCostPeriod.class.getCanonicalName(), new Object[]{this.projectGroupId}, network, fileName, timePeriod);
        initialLinkSegmentCostPeriod.setTimePeriod(timePeriod);
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCostPeriod);
        return initialLinkSegmentCostPeriod;
    }

    public List<InitialLinkSegmentCostPeriod> createAndRegisterInitialLinkSegmentCost(InfrastructureNetwork network, String fileName, Demands demands) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        ArrayList<InitialLinkSegmentCostPeriod> initialCostsList = new ArrayList<InitialLinkSegmentCostPeriod>();
        for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
            InitialLinkSegmentCostPeriod initialLinkSegmentCostPeriod = this.createAndRegisterInitialLinkSegmentCost(network, fileName, timePeriod);
            initialCostsList.add(initialLinkSegmentCostPeriod);
        }
        return initialCostsList;
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(InfrastructureNetwork network) {
        return this.initialLinkSegmentCosts.get(network);
    }

    public class ProjectODPathSets {
        public List<ODPathSets> toList() {
            return new ArrayList<ODPathSets>(PlanItProjectInput.this.odPathSetsMap.values());
        }

        public ODPathSets getODPathSets(long id) {
            return PlanItProjectInput.this.odPathSetsMap.get(id);
        }

        public int getNumberOfOdPathSets() {
            return PlanItProjectInput.this.odPathSetsMap.size();
        }

        public boolean hasRegisteredOdPathSets() {
            return !PlanItProjectInput.this.odPathSetsMap.isEmpty();
        }

        public ODPathSets getFirstOdPathSets() {
            return this.hasRegisteredOdPathSets() ? PlanItProjectInput.this.odPathSetsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectZonings {
        public List<Zoning> toList() {
            return new ArrayList<Zoning>(PlanItProjectInput.this.zoningsMap.values());
        }

        public Zoning getZoning(long id) {
            return PlanItProjectInput.this.zoningsMap.get(id);
        }

        public int getNumberOfZonings() {
            return PlanItProjectInput.this.zoningsMap.size();
        }

        public boolean hasRegisteredZonings() {
            return !PlanItProjectInput.this.zoningsMap.isEmpty();
        }

        public Zoning getFirstZoning() {
            return this.hasRegisteredZonings() ? PlanItProjectInput.this.zoningsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectDemands {
        public List<Demands> toList() {
            return new ArrayList<Demands>(PlanItProjectInput.this.demandsMap.values());
        }

        public Demands getDemands(long id) {
            return PlanItProjectInput.this.demandsMap.get(id);
        }

        public int getNumberOfDemands() {
            return PlanItProjectInput.this.demandsMap.size();
        }

        public boolean hasRegisteredDemands() {
            return !PlanItProjectInput.this.demandsMap.isEmpty();
        }

        public Demands getFirstDemands() {
            return this.hasRegisteredDemands() ? PlanItProjectInput.this.demandsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectNetworks {
        public List<InfrastructureNetwork> toList() {
            return new ArrayList<InfrastructureNetwork>(PlanItProjectInput.this.infrastructureNetworkMap.values());
        }

        public InfrastructureNetwork getInfrastructureNetwork(long id) {
            return PlanItProjectInput.this.infrastructureNetworkMap.get(id);
        }

        public int getNumberOfInfrastructureNetworks() {
            return PlanItProjectInput.this.infrastructureNetworkMap.size();
        }

        public boolean hasRegisteredInfrastructureNetworks() {
            return !PlanItProjectInput.this.infrastructureNetworkMap.isEmpty();
        }

        public InfrastructureNetwork getFirstInfrastructureNetwork() {
            return this.hasRegisteredInfrastructureNetworks() ? PlanItProjectInput.this.infrastructureNetworkMap.firstEntry().getValue() : null;
        }
    }
}

