/*
 * Decompiled with CFR 0.152.
 */
package org.planit.time;

import java.util.Comparator;
import java.util.logging.Logger;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class TimePeriod
implements ExternalIdable {
    private static final Logger LOGGER = Logger.getLogger(TimePeriod.class.getCanonicalName());
    private final long startTimeSeconds;
    private final long durationSeconds;
    private final long id;
    private String externalId;
    private String xmlId;
    private final String description;

    public static Comparator<TimePeriod> comparatorByStartTime() {
        Comparator<TimePeriod> sortOnStartTime = new Comparator<TimePeriod>(){

            @Override
            public int compare(TimePeriod o1, TimePeriod o2) {
                long startTimeDiff = o1.getStartTimeSeconds() - o2.getStartTimeSeconds();
                if (startTimeDiff != 0L) {
                    return (int)startTimeDiff;
                }
                return (int)(o1.getDurationSeconds() - o2.getDurationSeconds());
            }
        };
        return sortOnStartTime;
    }

    public TimePeriod(IdGroupingToken groupId, long startTimeSeconds, long durationSeconds) throws PlanItException {
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours");
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours");
        this.id = IdGenerator.generateId(groupId, TimePeriod.class);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = null;
    }

    public TimePeriod(IdGroupingToken groupId, String description, long startTimeSeconds, long durationSeconds) throws PlanItException {
        PlanItException.throwIf((double)durationSeconds > 86400.0, "Duration more than 24 hours");
        PlanItException.throwIf((double)startTimeSeconds > 86400.0, "Start time later than 24 hours");
        this.id = IdGenerator.generateId(groupId, TimePeriod.class);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = description;
    }

    public static long convertHoursToSeconds(String fourDigitHour) throws PlanItException {
        long startTime;
        PlanItException.throwIf(fourDigitHour.length() != 4, "Start time must contain exactly four digits");
        try {
            startTime = Integer.parseInt(fourDigitHour);
        }
        catch (NumberFormatException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Start time must contain exactly four digits", e);
        }
        PlanItException.throwIf(startTime < 0L, "Start time cannot be negative");
        PlanItException.throwIf(startTime > 2400L, "Start time cannot be later than 2400");
        long startTimeHrs = startTime / 100L;
        long startTimeMins = startTime % 100L;
        PlanItException.throwIf(startTimeMins > 59L, "Last two digits of start time cannot exceed 59");
        return startTimeHrs * 3600L + startTimeMins * 60L;
    }

    public static long convertHoursToSeconds(double hoursFromMidnight) {
        return Math.round(hoursFromMidnight * 3600.0);
    }

    public static float convertSecondsToHours(int secondsFromMidnight) {
        return (float)secondsFromMidnight / 3600.0f;
    }

    public long getStartTimeSeconds() {
        return this.startTimeSeconds;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getXmlId() {
        return this.xmlId;
    }

    @Override
    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public int hashCode() {
        return this.idHashCode();
    }

    public boolean equals(Object o) {
        return this.idEquals(o);
    }

    public String toString() {
        long endTime = this.startTimeSeconds + this.durationSeconds;
        return String.format("start time: %02d:%02d ", this.startTimeSeconds / 3600L, this.startTimeSeconds % 3600L / 60L) + String.format("- end time: %02d:%02d", endTime / 3600L, endTime % 3600L / 60L);
    }
}

