/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.cumulatives;

import org.planit.utils.cumulatives.CumulativePoint;

public class CumulativePointImpl
implements CumulativePoint {
    private static final long serialVersionUID = 630928063482940795L;
    final double cumulativeCount;
    final double referenceTimeInSeconds;

    public CumulativePointImpl(double cumulativeCount, double referenceTimeInSeconds) {
        this.cumulativeCount = cumulativeCount;
        this.referenceTimeInSeconds = referenceTimeInSeconds;
    }

    @Override
    public double getAbsTimeDifferenceWith(CumulativePoint otherCumulative) {
        return Math.abs(otherCumulative.getReferenceTimeInSeconds() - this.getReferenceTimeInSeconds());
    }

    @Override
    public double getAbsCumulativeDifferenceWith(CumulativePoint otherCumulative) {
        return Math.abs(otherCumulative.getCumulativeCount() - this.getCumulativeCount());
    }

    @Override
    public double computeAbsFlowRate(CumulativePoint adjacentCumulativePoint) {
        return this.getAbsCumulativeDifferenceWith(adjacentCumulativePoint) / this.getAbsTimeDifferenceWith(adjacentCumulativePoint);
    }

    @Override
    public boolean isLater(CumulativePoint otherCumulativePoint, double timeInSecondsEpsilon) {
        return this.getReferenceTimeInSeconds() - timeInSecondsEpsilon > otherCumulativePoint.getReferenceTimeInSeconds();
    }

    @Override
    public boolean isLaterOrEqual(CumulativePoint otherCumulativePoint, double timeInSecondsEpsilon) {
        return this.getReferenceTimeInSeconds() - timeInSecondsEpsilon >= otherCumulativePoint.getReferenceTimeInSeconds();
    }

    @Override
    public boolean isEarlier(CumulativePoint otherCumulativePoint, double timeInSecondsEpsilon) {
        return this.getReferenceTimeInSeconds() + timeInSecondsEpsilon < otherCumulativePoint.getReferenceTimeInSeconds();
    }

    @Override
    public boolean isEarlierOrEqual(CumulativePoint otherCumulativePoint, double timeInSecondsEpsilon) {
        return this.getReferenceTimeInSeconds() + timeInSecondsEpsilon <= otherCumulativePoint.getReferenceTimeInSeconds();
    }

    @Override
    public double getReferenceTimeInSeconds() {
        return this.referenceTimeInSeconds;
    }

    @Override
    public double getCumulativeCount() {
        return this.cumulativeCount;
    }
}

