/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.epsg;

import java.util.HashMap;
import java.util.logging.Logger;

public class EpsgCodesByCountry {
    private static final Logger LOGGER = Logger.getLogger(EpsgCodesByCountry.class.getCanonicalName());
    public static final String AUSTRALIA_LAMBERT = "EPSG:3112";
    public static final String GERMANY_DHDN = "EPSG:31468";
    public static final String NETHERLANDS_RDS = "EPSG:31468";
    public static final String WORLD_WG84 = "EPSG:4326";
    protected static final HashMap<String, String> countryToEpsgCodes = new HashMap();

    protected static void add(String countryName, String epsgCode) {
        countryToEpsgCodes.put(countryName, epsgCode);
    }

    public static final String getEpsg(String countryName) {
        return countryToEpsgCodes.get(countryName);
    }

    static {
        EpsgCodesByCountry.add("global", WORLD_WG84);
        EpsgCodesByCountry.add("Germany", "EPSG:31468");
        EpsgCodesByCountry.add("Netherlands", "EPSG:31468");
        EpsgCodesByCountry.add("Australia", AUSTRALIA_LAMBERT);
    }
}

