/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.graph;

import java.io.Serializable;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.ExternalIdable;

public interface Edge
extends Serializable,
ExternalIdable {
    public LineString getGeometry();

    public void setGeometry(LineString var1);

    default public boolean hasGeometry() {
        return this.getGeometry() != null;
    }

    default public boolean isGeometryInAbDirection() {
        boolean isVertexAStartPoint = this.getGeometry().getStartPoint().equals(this.getVertexA().getPosition());
        boolean isVertexBEndPoint = this.getGeometry().getEndPoint().equals(this.getVertexB().getPosition());
        return isVertexAStartPoint && isVertexBEndPoint;
    }

    default public void transformGeometry(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        this.setGeometry((LineString)JTS.transform(this.getGeometry(), transformer));
    }

    public boolean removeVertex(Vertex var1);

    public Vertex getVertexA();

    public Vertex getVertexB();

    public void setName(String var1);

    public String getName();

    public void setLengthKm(double var1);

    public double getLengthKm();

    public void addInputProperty(String var1, Object var2);

    public Object getInputProperty(String var1);

    public boolean replace(Vertex var1, Vertex var2) throws PlanItException;

    public Edge clone();

    public boolean validate();

    default public boolean hasVertex(Vertex vertex) {
        return this.getVertexA().equals(vertex) || this.getVertexB().equals(vertex);
    }
}

