/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.planit.utils.graph.Edge;
import org.planit.utils.id.ExternalIdable;

public interface Vertex
extends Serializable,
ExternalIdable {
    public void addInputProperty(String var1, Object var2);

    public void setPosition(Point var1);

    public Point getPosition();

    public boolean addEdge(Edge var1);

    public boolean removeEdge(Edge var1);

    public boolean removeEdge(long var1);

    public Collection<? extends Edge> getEdges();

    public int getNumberOfEdges();

    public Set<Edge> getEdges(Vertex var1);

    public Vertex clone();

    public boolean validate();

    default public boolean replace(Edge edgeToReplace, Edge edgeToReplaceWith, boolean forceInsert) {
        if (this.removeEdge(edgeToReplace)) {
            return this.addEdge(edgeToReplaceWith);
        }
        return false;
    }

    default public void transformPosition(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        this.setPosition((Point)JTS.transform(this.getPosition(), transformer));
    }
}

