/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.misc;

import java.util.Objects;

public class Pair<A, B> {
    protected final A first;
    protected final B second;

    protected Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> create(A valueA, B valueB) {
        return new Pair<A, B>(valueA, valueB);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object other) {
        if (other instanceof Pair) {
            Pair otherPair = (Pair)other;
            return (this.first == otherPair.first || this.first != null && otherPair.first != null && this.first.equals(otherPair.first)) && (this.second == otherPair.second || this.second != null && otherPair.second != null && this.second.equals(otherPair.second));
        }
        return false;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public boolean anyIsNotNull() {
        return this.first() != null || this.second() != null;
    }

    public boolean bothNotNull() {
        return this.first() != null && this.second() != null;
    }

    public boolean isExactlyOneNonNull() {
        return this.anyIsNotNull() && !this.bothNotNull();
    }

    public Object getEarliestNonNull() {
        if (this.first() != null) {
            return this.first();
        }
        return this.second();
    }
}

