/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.network.physical.macroscopic;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.planit.utils.id.ExternalIdable;
import org.planit.utils.mode.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public interface MacroscopicLinkSegmentType
extends Cloneable,
ExternalIdable {
    public static final double DEFAULT_CAPACITY_LANE = 1800.0;
    public static final double DEFAULT_MAX_DENSITY_LANE = 180.0;
    public static final String DEFAULT_XML_ID = "1";

    public String getName();

    public void setName(String var1);

    public double getCapacityPerLane();

    public double getMaximumDensityPerLane();

    public void setModeProperties(Map<Mode, MacroscopicModeProperties> var1);

    public MacroscopicModeProperties addModeProperties(Mode var1, MacroscopicModeProperties var2);

    public MacroscopicModeProperties removeModeProperties(Mode var1);

    default public void removeModeProperties(Set<Mode> toBeRemovedModes) {
        toBeRemovedModes.forEach(mode -> this.removeModeProperties((Mode)mode));
    }

    public MacroscopicModeProperties getModeProperties(Mode var1);

    public boolean isModeAvailable(Mode var1);

    public Set<Mode> getAvailableModes();

    default public Set<Mode> getUnAvailableModesFrom(Collection<Mode> modes) {
        return modes.stream().filter(mode -> !this.isModeAvailable((Mode)mode)).collect(Collectors.toSet());
    }

    default public Set<Mode> getAvailableModesFrom(Collection<Mode> modes) {
        return modes.stream().filter(mode -> this.isModeAvailable((Mode)mode)).collect(Collectors.toSet());
    }

    default public boolean hasAvailableModes() {
        return this.getAvailableModes() != null && !this.getAvailableModes().isEmpty();
    }

    public MacroscopicLinkSegmentType clone();
}

