/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.unit;

import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.unit.Units;

public class UnitUtils {
    private static final double HOUR_2_MINUTE = 60.0;
    private static final double MINUTE_2_HOUR = 0.016666666666666666;
    private static final double MINUTE_2_SECOND = 60.0;
    private static final double SECOND_2_MINUTE = 0.016666666666666666;
    private static final double HOUR_2_SECOND = 3600.0;
    private static final double SECOND_2_HOUR = 2.777777777777778E-4;
    private static final double KM_2_METER = 1000.0;
    private static final double METER_2_KM = 0.001;

    private static double convertVehiclesPerSecondTo(Units to, double value) throws PlanItException {
        switch (to) {
            case VEH_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.SECOND, value);
            }
            case VEH_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.SECOND, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.VEH_SECOND, to}));
    }

    private static double convertVehiclesPerMinuteTo(Units to, double value) throws PlanItException {
        switch (to) {
            case VEH_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.MINUTE, value);
            }
            case VEH_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.MINUTE, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.VEH_MINUTE, to}));
    }

    private static double convertVehiclesPerHourTo(Units to, double value) throws PlanItException {
        switch (to) {
            case VEH_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.HOUR, value);
            }
            case VEH_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.HOUR, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.VEH_HOUR, to}));
    }

    private static double convertSecondTo(Units to, double value) throws PlanItException {
        switch (to) {
            case HOUR: {
                return value * 2.777777777777778E-4;
            }
            case MINUTE: {
                return value * 0.016666666666666666;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.SECOND, to}));
    }

    private static double convertMinuteTo(Units to, double value) throws PlanItException {
        switch (to) {
            case HOUR: {
                return value * 0.016666666666666666;
            }
            case SECOND: {
                return value * 60.0;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.MINUTE, to}));
    }

    private static double convertHourTo(Units to, double value) throws PlanItException {
        switch (to) {
            case MINUTE: {
                return value * 60.0;
            }
            case SECOND: {
                return value * 3600.0;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.HOUR, to}));
    }

    private static double convertMeterTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM: {
                return value * 0.001;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.METER, to}));
    }

    private static double convertKmTo(Units to, double value) throws PlanItException {
        switch (to) {
            case METER: {
                return value * 1000.0;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.KM, to}));
    }

    private static double convertKmSecTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.SECOND, value);
            }
            case KM_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.SECOND, value);
            }
            case METER_HOUR: {
                return UnitUtils.convertMeterSecondTo(Units.METER_HOUR, UnitUtils.convert(Units.KM, Units.METER, value));
            }
            case METER_MINUTE: {
                return UnitUtils.convertMeterSecondTo(Units.METER_MINUTE, UnitUtils.convert(Units.KM, Units.METER, value));
            }
            case METER_SECOND: {
                return UnitUtils.convert(Units.KM, Units.METER, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.KM_SECOND, to}));
    }

    private static double convertKmMinTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.MINUTE, value);
            }
            case KM_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.MINUTE, value);
            }
            case METER_HOUR: {
                return UnitUtils.convertMeterMinuteTo(Units.METER_HOUR, UnitUtils.convert(Units.KM, Units.METER, value));
            }
            case METER_MINUTE: {
                return UnitUtils.convert(Units.KM, Units.METER, value);
            }
            case METER_SECOND: {
                return UnitUtils.convertMeterMinuteTo(Units.METER_SECOND, UnitUtils.convert(Units.KM, Units.METER, value));
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.KM_MINUTE, to}));
    }

    private static double convertKmHourTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.HOUR, value);
            }
            case KM_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.HOUR, value);
            }
            case METER_HOUR: {
                return UnitUtils.convert(Units.KM, Units.METER, value);
            }
            case METER_MINUTE: {
                return UnitUtils.convertMeterHourTo(Units.METER_MINUTE, UnitUtils.convert(Units.KM, Units.METER, value));
            }
            case METER_SECOND: {
                return UnitUtils.convertMeterHourTo(Units.METER_SECOND, UnitUtils.convert(Units.KM, Units.METER, value));
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.KM_HOUR, to}));
    }

    private static double convertMeterHourTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_HOUR: {
                return UnitUtils.convert(Units.METER, Units.KM, value);
            }
            case KM_MINUTE: {
                return UnitUtils.convertKmHourTo(Units.KM_MINUTE, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case KM_SECOND: {
                return UnitUtils.convertKmHourTo(Units.KM_SECOND, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case METER_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.HOUR, value);
            }
            case METER_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.HOUR, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.METER_HOUR, to}));
    }

    private static double convertMeterMinuteTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_HOUR: {
                return UnitUtils.convertKmMinTo(Units.KM_HOUR, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case KM_MINUTE: {
                return UnitUtils.convert(Units.METER, Units.KM, value);
            }
            case KM_SECOND: {
                return UnitUtils.convertKmMinTo(Units.KM_SECOND, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case METER_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.MINUTE, value);
            }
            case METER_SECOND: {
                return UnitUtils.convert(Units.SECOND, Units.MINUTE, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.METER_MINUTE, to}));
    }

    private static double convertMeterSecondTo(Units to, double value) throws PlanItException {
        switch (to) {
            case KM_HOUR: {
                return UnitUtils.convertKmSecTo(Units.KM_HOUR, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case KM_MINUTE: {
                return UnitUtils.convertKmSecTo(Units.KM_MINUTE, UnitUtils.convert(Units.METER, Units.KM, value));
            }
            case KM_SECOND: {
                return UnitUtils.convert(Units.METER, Units.KM, value);
            }
            case METER_HOUR: {
                return UnitUtils.convert(Units.HOUR, Units.SECOND, value);
            }
            case METER_MINUTE: {
                return UnitUtils.convert(Units.MINUTE, Units.SECOND, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.METER_SECOND, to}));
    }

    private static double convertVehiclesPerMeterTo(Units to, double value) throws PlanItException {
        switch (to) {
            case VEH_KM: {
                return UnitUtils.convert(Units.KM, Units.METER, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.METER, to}));
    }

    private static double convertVehiclesPerKmTo(Units to, double value) throws PlanItException {
        switch (to) {
            case VEH_METER: {
                return UnitUtils.convert(Units.METER, Units.KM, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{Units.VEH_KM, to}));
    }

    public static double convert(Units from, Units to, double value) throws PlanItException {
        switch (from) {
            case KM_HOUR: {
                return UnitUtils.convertKmHourTo(to, value);
            }
            case KM_MINUTE: {
                return UnitUtils.convertKmMinTo(to, value);
            }
            case KM_SECOND: {
                return UnitUtils.convertKmSecTo(to, value);
            }
            case METER_SECOND: {
                return UnitUtils.convertMeterSecondTo(to, value);
            }
            case METER_MINUTE: {
                return UnitUtils.convertMeterMinuteTo(to, value);
            }
            case METER_HOUR: {
                return UnitUtils.convertMeterHourTo(to, value);
            }
            case KM: {
                return UnitUtils.convertKmTo(to, value);
            }
            case METER: {
                return UnitUtils.convertMeterTo(to, value);
            }
            case MINUTE: {
                return UnitUtils.convertMinuteTo(to, value);
            }
            case SECOND: {
                return UnitUtils.convertSecondTo(to, value);
            }
            case HOUR: {
                return UnitUtils.convertHourTo(to, value);
            }
            case VEH_HOUR: {
                return UnitUtils.convertVehiclesPerHourTo(to, value);
            }
            case VEH_MINUTE: {
                return UnitUtils.convertVehiclesPerMinuteTo(to, value);
            }
            case VEH_SECOND: {
                return UnitUtils.convertVehiclesPerSecondTo(to, value);
            }
            case VEH_KM: {
                return UnitUtils.convertVehiclesPerKmTo(to, value);
            }
            case VEH_METER: {
                return UnitUtils.convertVehiclesPerMeterTo(to, value);
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{from, to}));
    }
}

