/*
 * Decompiled with CFR 0.152.
 */
package org.planit.zoning;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.ExternalIdAbleImpl;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.mode.Mode;
import org.planit.utils.zoning.Connectoid;
import org.planit.utils.zoning.ConnectoidType;
import org.planit.utils.zoning.Zone;

public abstract class ConnectoidImpl
extends ExternalIdAbleImpl
implements Connectoid {
    private static final long serialVersionUID = 373775073620741347L;
    private static final Logger LOGGER = Logger.getLogger(ConnectoidImpl.class.getCanonicalName());
    protected String name = null;
    protected ConnectoidType type = DEFAULT_CONNECTOID_TYPE;
    protected final HashMap<Long, AccessZoneProperties> accessZones = new HashMap();

    protected static long generateConnectoidId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Connectoid.class);
    }

    protected ConnectoidImpl(IdGroupingToken idToken) {
        super(ConnectoidImpl.generateConnectoidId(idToken));
    }

    protected ConnectoidImpl(ConnectoidImpl connectoidImpl) {
        super(connectoidImpl);
        for (AccessZoneProperties entry : connectoidImpl.accessZones.values()) {
            this.accessZones.put(entry.accessZone.getId(), new AccessZoneProperties(entry));
        }
    }

    protected ConnectoidImpl(IdGroupingToken idToken, Zone accessZone, double length) {
        this(idToken);
        this.addAccessZone(accessZone);
        this.setLength(accessZone, length);
    }

    @Override
    public void setType(ConnectoidType type) {
        this.type = type;
    }

    @Override
    public ConnectoidType getType() {
        return this.type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Zone> getAccessZones() {
        return this.accessZones.values().stream().map(amp -> amp.accessZone).collect(Collectors.toList());
    }

    @Override
    public Zone getFirstAccessZone() {
        return this.iterator().next();
    }

    @Override
    public long getNumberOfAccessZones() {
        return this.accessZones.size();
    }

    @Override
    public Double getLength(Zone accessZone) {
        if (!this.hasAccessZone(accessZone)) {
            LOGGER.warning(String.format("unknown access zone %s for connectoid %s", accessZone.getXmlId(), this.getXmlId()));
            return null;
        }
        return this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).length;
    }

    @Override
    public Zone addAccessZone(Zone accessZone) {
        AccessZoneProperties duplicate = this.accessZones.put(accessZone.getId(), new AccessZoneProperties(accessZone));
        return duplicate != null ? duplicate.accessZone : null;
    }

    @Override
    public boolean isModeAllowed(Zone accessZone, Mode mode) throws PlanItException {
        if (!this.hasAccessZone(accessZone)) {
            LOGGER.warning(String.format("unknown access zone %s for connectoid %s", accessZone.getXmlId(), this.getXmlId()));
            return false;
        }
        HashMap<Long, Mode> allowedModes = this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).allowedModes;
        return allowedModes != null ? allowedModes.containsKey(mode.getId()) : true;
    }

    @Override
    public boolean hasAccessZone(Zone accessZone) {
        if (accessZone == null) {
            return false;
        }
        return this.accessZones.containsKey(accessZone.getId());
    }

    @Override
    public void setLength(Zone accessZone, double length) {
        if (this.hasAccessZone(accessZone)) {
            this.accessZones.get((Object)Long.valueOf((long)accessZone.getId())).length = length;
        } else {
            LOGGER.warning(String.format("unknown access zone %s for connectoid %s", accessZone.getXmlId(), this.getXmlId()));
        }
    }

    @Override
    public void addAllowedMode(Zone accessZone, Mode ... allowedModes) {
        if (this.hasAccessZone(accessZone)) {
            AccessZoneProperties accessZoneProperties = this.accessZones.get(accessZone.getId());
            Arrays.asList(allowedModes).forEach(allowedMode -> accessZoneProperties.addAllowedMode((Mode)allowedMode));
        } else {
            LOGGER.warning(String.format("unknown access zone %s for connectoid %s", accessZone.getXmlId(), this.getXmlId()));
        }
    }

    @Override
    public Iterator<Zone> iterator() {
        Iterator<Zone> it = new Iterator<Zone>(){
            private Iterator<AccessZoneProperties> iterator;
            {
                this.iterator = ConnectoidImpl.this.accessZones.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Zone next() {
                return this.iterator.next().accessZone;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }

    protected class AccessZoneProperties {
        public final Zone accessZone;
        public Double length = 0.0;
        public HashMap<Long, Mode> allowedModes = null;

        protected AccessZoneProperties(Zone accessZone) {
            this.accessZone = accessZone;
        }

        public AccessZoneProperties(AccessZoneProperties other) {
            this.accessZone = other.accessZone;
            this.length = other.length;
            if (other.allowedModes != null) {
                this.allowedModes = (HashMap)other.allowedModes.clone();
            }
        }

        void addAllowedMode(Mode mode) {
            if (this.allowedModes == null) {
                this.allowedModes = new HashMap();
            }
            this.allowedModes.put(mode.getId(), mode);
        }
    }
}

